# PayPal Webhook Setup Guide

This Laravel 5 application has been updated to use PayPal's modern webhook system instead of the deprecated IPN system.

## What Changed

1. **Removed**: Old IPN listener dependency (`wadeshuler/php-paypal-ipn`)
2. **Added**: Modern webhook handler that processes PayPal webhook events
3. **Enhanced**: Better error handling and logging
4. **Improved**: Security with webhook signature verification

## Setup Instructions

### 1. PayPal App Configuration

1. Log into your [PayPal Developer Dashboard](https://developer.paypal.com/)
2. Go to your existing app or create a new one
3. Navigate to the "Webhooks" section
4. Add a new webhook with the URL: `https://yourdomain.com/donate/paypal/webhook`
5. Select these event types:
   - `PAYMENT.SALE.COMPLETED`
   - `PAYMENT.SALE.DENIED`
   - `PAYMENT.SALE.REFUNDED`

### 2. Application Configuration

1. Go to Admin → Donate Settings
2. Fill in your PayPal credentials as before
3. **New**: Add your Webhook ID (optional but recommended for production)
   - Find this in your PayPal app's webhook settings
   - Used for webhook signature verification

### 3. Testing

1. Make a test donation through your site
2. Check your application logs for webhook events
3. Verify that payments are processed correctly

## How It Works

### Payment Flow
1. User submits donation form
2. PayPal processes payment
3. User returns to your site (immediate feedback)
4. PayPal sends webhook notification (background processing)
5. Webhook handler processes the payment and updates user balance

### Webhook Events Handled
- **PAYMENT.SALE.COMPLETED**: Adds money to user account
- **PAYMENT.SALE.DENIED**: Logs the failed payment
- **PAYMENT.SALE.REFUNDED**: Removes money from user account

### Security Features
- CSRF protection bypassed for webhook endpoint (required)
- Optional webhook signature verification
- Duplicate payment prevention
- Comprehensive error logging

## Troubleshooting

### Check Logs
```bash
tail -f storage/logs/laravel.log
```

### Common Issues
1. **Webhook not receiving events**: Check your PayPal webhook URL configuration
2. **Signature verification failing**: Ensure webhook ID is correct or leave empty
3. **Duplicate payments**: The system prevents this automatically
4. **User not found**: Check that custom data includes valid user ID

### Webhook URL
Your webhook endpoint is: `https://yourdomain.com/donate/paypal/webhook`

Make sure this URL is:
- Publicly accessible
- Using HTTPS (required by PayPal)
- Not behind authentication

## Migration Notes

- Existing payments continue to work
- No database changes required
- Old IPN code has been replaced with webhook handling
- All existing settings are preserved

## Support

If you encounter issues:
1. Check the application logs
2. Verify PayPal webhook configuration
3. Test with PayPal's webhook simulator
4. Ensure your server can receive HTTPS requests