<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use DB;
use Carbon\Carbon;

class IndexController extends Controller
{
    /*
    protected $github;

    public function __construct( GitHubManager $github )
    {
        $this->github = $github;
    }*/

    public function getIndex()
    {
        //$releases = $this->github->api( 'repo' )->releases()->all( 'huludini', 'pw-web' );
        pagetitle([trans('main.dashboard'), settings('server_name')]);
        // build last 12 months labels and counts
        $labels = [];
        $registrations = [];
        $spins = [];

        for ($i = 11; $i >= 0; $i--) {
            $dt = Carbon::now()->subMonths($i);
            $start = $dt->copy()->startOfMonth()->toDateTimeString();
            $end = $dt->copy()->endOfMonth()->toDateTimeString();
            $labels[] = $dt->format('M Y');

            // users table may be named 'users' and use created_at
            $registrations[] = DB::table('users')
                ->whereBetween('created_at', [$start, $end])
                ->count();

            // daily_spins table optional
            try {
                $spins[] = DB::table('daily_spins')
                    ->whereBetween('created_at', [$start, $end])
                    ->count();
            } catch (\Exception $e) {
                // if table doesn't exist, default to 0
                $spins[] = 0;
            }
        }

        return view('admin.index', [
            'chartLabels' => $labels,
            'registrationsData' => $registrations,
            'spinsData' => $spins,
        ]);
    }
}
