<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;

class SimpleCaptchaController extends Controller
{
    public function generate()
    {
        // Generate simple text captcha
        $characters = '23456789ABCDEFGHJKLMNPQRSTUVWXYZ';
        $captchaText = '';
        for ($i = 0; $i < 5; $i++) {
            $captchaText .= $characters[rand(0, strlen($characters) - 1)];
        }
        
        // Store in session
        Session::put('simple_captcha', strtolower($captchaText));
        
        // Create simple image
        $width = 150;
        $height = 50;
        
        // Create image
        $image = imagecreate($width, $height);
        
        // Colors for dark theme
        $bgColor = imagecolorallocate($image, 45, 55, 72);    // Dark background
        $textColor = imagecolorallocate($image, 255, 255, 255); // White text
        $lineColor = imagecolorallocate($image, 100, 116, 139); // Gray lines
        
        // Fill background
        imagefill($image, 0, 0, $bgColor);
        
        // Add some noise lines
        for ($i = 0; $i < 5; $i++) {
            imageline($image, rand(0, $width), rand(0, $height), rand(0, $width), rand(0, $height), $lineColor);
        }
        
        // Add text
        $fontSize = 5;
        $textWidth = strlen($captchaText) * imagefontwidth($fontSize);
        $textHeight = imagefontheight($fontSize);
        $x = ($width - $textWidth) / 2;
        $y = ($height - $textHeight) / 2;
        
        // Add each character with slight randomization
        for ($i = 0; $i < strlen($captchaText); $i++) {
            $charX = $x + ($i * imagefontwidth($fontSize)) + rand(-2, 2);
            $charY = $y + rand(-3, 3);
            imagestring($image, $fontSize, $charX, $charY, $captchaText[$i], $textColor);
        }
        
        // Output image
        header('Content-Type: image/png');
        header('Cache-Control: no-cache, no-store, must-revalidate');
        header('Pragma: no-cache');
        header('Expires: 0');
        
        imagepng($image);
        imagedestroy($image);
        exit;
    }
    
    public static function validate($input)
    {
        $sessionCaptcha = Session::get('simple_captcha');
        Session::forget('simple_captcha');
        
        return $sessionCaptcha && strtolower($input) === $sessionCaptcha;
    }
}