<?php

namespace App\Http\Requests;

use App\Http\Requests\Request;
use App\Http\Controllers\CaptchaController;

class CaptchaRequest extends Request
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'captcha' => 'required|captcha_valid',
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'captcha.required' => 'Please enter the captcha code.',
            'captcha.captcha_valid' => 'The captcha code is incorrect.',
        ];
    }
}