<?php

use Illuminate\Support\Facades\App;

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

/* Math Captcha Routes */
Route::post('captcha/refresh', 'MathCaptchaController@refresh');
Route::post('captcha/refresh-reg', 'MathCaptchaController@refreshReg');

/* Auth */
Route::controller( 'auth', 'Auth\AuthController', [
    'getRegister' => 'auth.register',
    'getLogin'    => 'auth.login',
]);

Route::get( 'account/settings', ['as' => 'account.settings', 'uses' => 'Front\AccountController@getSettings'] );
Route::post( 'account/settings/email', 'Front\AccountController@postEmail' );
Route::post( 'account/settings/password', 'Front\AccountController@postPassword' );

/* Character */
Route::get( 'character/select/{role_id}', 'Front\CharacterController@getSelect' );

/* Wiki */
Route::get( 'wiki', 'Front\WikiController@getIndex' );
Route::get( 'wiki/category/{category}', 'Front\WikiController@getCategory' );
Route::get( 'wiki/{slug}', 'Front\WikiController@getArticle' );



// Password reset link request routes...
Route::post( 'password/email', 'Auth\PasswordController@postEmail' );

// Password reset routes...
Route::get( 'password/reset/{token}', 'Auth\PasswordController@getReset' );
Route::post( 'password/reset', 'Auth\PasswordController@postReset' );

/* News */
Route::get( '/', ['as' => 'news.index', 'uses' => 'Front\NewsController@getIndex'] );

/* Shop */
Route::get( 'shop', ['as' => 'shop.index', 'uses' => 'Front\ShopController@getIndex'] );
Route::post( 'shop/purchase/{shop}', 'Front\ShopController@postPurchase' );
Route::post( 'shop/gift/{shop}', 'Front\ShopController@postGift' );
Route::get( 'shop/mask/{shop_mask}', ['as' => 'shop.mask', 'uses' => 'Front\ShopController@getMask'] );

/* Donate */
Route::get( 'donate', ['as' => 'donate.index', 'uses' => 'Front\DonateController@getIndex'] );
Route::post( 'donate/paypal', 'Front\DonateController@postPaypalSubmit' );
Route::get( 'donate/paypal/complete', 'Front\DonateController@postPayPalComplete' );
Route::post( 'donate/paypal/webhook', 'Front\DonateController@postPaypalWebhook' );
Route::get( 'donate/paymentwall', 'Front\DonateController@getPaymentwall' );

/* Vote */
Route::get( 'vote', ['as' => 'vote.index', 'uses' => 'Front\VoteController@getIndex'] );
Route::get( 'vote/success/{vote}', ['as' => 'vote.success', 'uses' => 'Front\VoteController@getSuccess'] );
Route::post( 'vote/check/{vote}', 'Front\VoteController@postCheck' );

/* Voucher */
Route::get( 'voucher', ['as' => 'voucher.index', 'uses' => 'Front\VoucherController@getIndex'] );
Route::post( 'voucher/redeem', 'Front\VoucherController@postRedeem' );

/* Services */
Route::get( 'services', ['as' => 'services.index', 'uses' => 'Front\ServicesController@getIndex'] );
Route::post( 'services/{service}', 'Front\ServicesController@postPurchase' );

/* Daily Spin */
Route::get( 'daily-spin', ['as' => 'daily-spin.index', 'uses' => 'Front\DailySpinController@getIndex'] );
Route::post( 'daily-spin/spin', 'Front\DailySpinController@postSpin' );

/* Ranking */
Route::get('ranking', 'Front\RankingController@getIndex');
Route::get('ranking/player/{sub}', ['as' => 'ranking.player', 'uses' => 'Front\RankingController@getPlayer']);
Route::get('ranking/faction', function () {
    return redirect('ranking/faction/level');
});

// Public debug endpoint (temporary) to verify routing without auth middleware
Route::get('_debug/scheduled-broadcasts/ping', 'Admin\ManagementController@getScheduledBroadcastDebug');
Route::get('ranking/faction/{sub}', ['as' => 'ranking.faction', 'uses' => 'Front\RankingController@getFaction']);

/* Not Working */
//Route::get( 'ranking/territory', ['as' => 'ranking.index', 'uses' => 'Front\RankingController@getTerritory'] );

/* Admin */
Route::group( ['prefix' => 'admin', 'middleware' => ['auth', 'admin'] ], function() {

    Route::get( '/', ['as' => 'admin.index', 'uses' => 'Admin\IndexController@getIndex'] );

    /* Members */
    Route::get( 'members/manage', ['as' => 'admin.members.manage', 'uses' => 'Admin\MembersController@getManage'] );
    // Debug: isolated modal test page
    Route::get( 'members/manage-modal', function() { return view('admin.members.manage_modal_test'); } );
    Route::post( 'members/balance/{user}', 'Admin\MembersController@postBalance' );
    Route::post( 'members/email/{user}', 'Admin\MembersController@postEmail' );
    Route::post( 'members/password/{user}', 'Admin\MembersController@postPassword' );
    Route::post( 'members/search', 'Admin\MembersController@postSearch' );
    Route::post( 'members/role/{user}', 'Admin\MembersController@postRole' );
    Route::post( 'members/update/{user}', 'Admin\MembersController@postUpdate' );

    /* System */
    Route::group( ['prefix' => 'system', 'as' => 'admin.system.'], function() {

        Route::get( 'settings', ['as' => 'settings', 'uses' => 'Admin\SystemController@getSettings'] );
        Route::post( 'settings', 'Admin\SystemController@postSettings' );
        Route::get( 'apps', ['as' => 'apps', 'uses' => 'Admin\SystemController@getApps'] );
        Route::post( 'apps', 'Admin\SystemController@postApps' );

//        Route::get( 'widget', ['as' => 'widget', 'uses' => 'Admin\SystemController@getWidget'] );
//        Route::post( 'widget', 'Admin\SystemController@postWidget' );

    });

    /* News */
    Route::get( 'news/settings', ['as' => 'admin.news.settings', 'uses' => 'Admin\NewsController@getSettings'] );
    Route::post( 'news/settings', 'Admin\NewsController@postSettings' );
    // Compatibility: old URL /admin/news/view used in some places — redirect to index
    Route::get('news/view', function() { return redirect('admin/news'); });
    // Image upload endpoint for Summernote used in the news editor
    Route::post('news/upload-image', 'Admin\NewsController@uploadImage');
    Route::resource( 'news', 'Admin\NewsController' );

    /* Shop */
    Route::get( 'shop/settings', ['as' => 'admin.shop.settings', 'uses' => 'Admin\ShopController@getSettings'] );
    Route::post( 'shop/settings', 'Admin\ShopController@postSettings' );
    // Compatibility: old URL /admin/shop/view used in some places — redirect to index
    Route::get('shop/view', function() { return redirect('admin/shop'); });
    Route::resource( 'shop', 'Admin\ShopController' );

    /* Donate */
    Route::get( 'donate/settings', ['as' => 'admin.donate.settings', 'uses' => 'Admin\DonateController@getSettings'] );
    Route::post( 'donate/paypal', 'Admin\DonateController@postPaypalSettings' );
    Route::post( 'donate/paymentwall', 'Admin\DonateController@postPaymentwallSettings' );

    /* Voucher */
    // Compatibility: old URL /admin/voucher/view used in some places — redirect to index
    Route::get('voucher/view', function() { return redirect('admin/voucher'); });
    Route::resource( 'voucher', 'Admin\VoucherController' );

    /* Vote */
    // Compatibility: old URL /admin/vote/view used in some places — redirect to index
    Route::get('vote/view', function() { return redirect('admin/vote'); });
    Route::resource( 'vote', 'Admin\VoteController' );

    /* Services */
    Route::get('services', ['as' => 'admin.services.edit', 'uses' => 'Admin\ServicesController@getEdit']);
    // Compatibility: old URL /admin/services/view used in some places — redirect to index
    Route::get('services/view', function() { return redirect('admin/services'); });
    Route::post('services', 'Admin\ServicesController@postEdit');
    Route::get('services/settings', ['as' => 'admin.services.settings', 'uses' => 'Admin\ServicesController@getSettings']);
    Route::post('services/settings', 'Admin\ServicesController@postSettings');

    /* Ranking */
    Route::get('ranking/settings', ['as' => 'admin.ranking.settings', 'uses' => 'Admin\RankingController@getSettings']);
    Route::post('ranking/settings', 'Admin\RankingController@postSettings');
    Route::get('ranking/settings/updatePlayer', 'Admin\RankingController@updatePlayer');
    Route::get('ranking/settings/updateFaction', 'Admin\RankingController@updateFaction');
    Route::get('ranking/settings/updateTerritories', 'Admin\RankingController@updateTerritories');

    /* Daily Spin */
    Route::get('daily-spin/settings', ['as' => 'admin.daily-spin.settings', 'uses' => 'Admin\DailySpinController@getSettings']);
    Route::post('daily-spin/settings', 'Admin\DailySpinController@postSettings');

    /* Wiki */
    Route::get('wiki', ['as' => 'admin.wiki.index', 'uses' => 'Admin\WikiController@getIndex']);
    Route::get('wiki/create', ['as' => 'admin.wiki.create', 'uses' => 'Admin\WikiController@getCreate']);
    Route::post('wiki/create', 'Admin\WikiController@postCreate');
    Route::get('wiki/edit/{id}', ['as' => 'admin.wiki.edit', 'uses' => 'Admin\WikiController@getEdit']);
    Route::post('wiki/edit/{id}', 'Admin\WikiController@postEdit');
    Route::get('wiki/delete/{id}', ['as' => 'admin.wiki.delete', 'uses' => 'Admin\WikiController@getDelete']);
    // Compatibility: old URL /admin/wiki/view used in some places — redirect to index
    Route::get('wiki/view', function() { return redirect('admin/wiki'); });

    /* Management */
    Route::get('management/gm', ['as' => 'admin.management.gm.view', 'uses' => 'Admin\ManagementController@getGM']);
    Route::post('management/gm', 'Admin\ManagementController@postGM');
    Route::get('management/gm/edit/{user}', ['as' => 'admin.management.gm.edit', 'uses' => 'Admin\ManagementController@getGMEdit']);
    Route::post('management/gm/edit/{user}', 'Admin\ManagementController@postGMEdit');
    Route::get('management/gm/remove/{user}', 'Admin\ManagementController@getGMRemove');
    Route::get('management/chat/watch', ['as' => 'admin.management.chat.watch', 'uses' => 'Admin\ManagementController@getChatWatch']);
    Route::post('management/chat/logs', 'Admin\ManagementController@postChatLogs');
    Route::get('management/chat/settings', ['as' => 'admin.management.chat.settings', 'uses' => 'Admin\ManagementController@getChatSettings']);
    Route::post( 'management/chat/settings', 'Admin\ManagementController@postChatSettings' );
    Route::controller( 'management', 'Admin\ManagementController', [
        'getBroadcast' => 'admin.management.broadcast',
        'getMailer' => 'admin.management.mailer',
        'getForbid' => 'admin.management.forbid'
    ]);

    /* Auto Broadcast Settings */
    Route::get('management/auto-broadcast-settings', ['as' => 'admin.management.auto-broadcast-settings', 'uses' => 'Admin\ManagementController@getAutoBroadcastSettings']);
    Route::post('management/auto-broadcast-settings', 'Admin\ManagementController@postAutoBroadcastSettings');

    /* Widget Links Settings */
    Route::get('management/widget-links', ['as' => 'admin.management.widget-links', 'uses' => 'Admin\ManagementController@getWidgetLinks']);
    Route::post('management/widget-links', 'Admin\ManagementController@postWidgetLinks');

    /* Scheduled Broadcasts */
    Route::get('management/scheduled-broadcasts', ['as' => 'admin.management.scheduled-broadcasts.index', 'uses' => 'Admin\ManagementController@getScheduledBroadcasts']);
    Route::get('management/scheduled-broadcasts/create', ['as' => 'admin.management.scheduled-broadcasts.create', 'uses' => 'Admin\ManagementController@getScheduledBroadcastCreate']);
    Route::post('management/scheduled-broadcasts/create', 'Admin\ManagementController@postScheduledBroadcastCreate');
    Route::get('management/scheduled-broadcasts/debug-submit', 'Admin\ManagementController@getScheduledBroadcastDebug');
    Route::get('management/scheduled-broadcasts/edit/{broadcast}', ['as' => 'admin.management.scheduled-broadcasts.edit', 'uses' => 'Admin\ManagementController@getScheduledBroadcastEdit']);
    Route::post('management/scheduled-broadcasts/edit/{broadcast}', 'Admin\ManagementController@postScheduledBroadcastEdit');
    Route::get('management/scheduled-broadcasts/delete/{broadcast}', 'Admin\ManagementController@getScheduledBroadcastDelete');
});

/* Installer */
Route::group( ['prefix' => 'admin/install', 'as' => 'admin.installer.'], function()
{
    Route::group( ['middleware' => 'installed'], function()
    {
        get( '/', [
            'as' => 'welcome',
            'uses' => 'Admin\InstallController@welcome'
        ]);

        get( 'settings', [
            'as' => 'settings',
            'uses' => 'Admin\InstallController@getSettings'
        ]);

        post( 'setup', [
            'as' => 'settings.save',
            'uses' => 'Admin\InstallController@postSettings'
        ]);

        /*get( 'environment', [
            'as' => 'environment',
            'uses' => 'Admin\InstallController@environment'
        ]);

        post( 'environment/save', [
            'as' => 'environment.save',
            'uses' => 'Admin\InstallController@save'
        ]);

        get( 'requirements', [
            'as' => 'requirements',
            'uses' => 'Admin\InstallController@requirements'
        ]);

        get( 'permissions', [
            'as' => 'permissions',
            'uses' => 'Admin\InstallController@permissions'
        ]);

        get( 'database', [
            'as' => 'database',
            'uses' => 'Admin\InstallController@database'
        ]);*/

        get( 'complete', [
            'as' => 'complete',
            'uses' => 'Admin\InstallController@complete'
        ]);
    });
});
