<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        // Math captcha validation rule
        \Validator::extend('captcha', function ($attribute, $value, $parameters, $validator) {
            $data = $validator->getData();
            if (isset($data['name']) && isset($data['email'])) {
                // Registration form
                return \App\Http\Controllers\MathCaptchaController::validateReg($value);
            } else {
                // Login form
                return \App\Http\Controllers\MathCaptchaController::validate($value);
            }
        });
    }

    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }
}
