<?php

// Simple database connection
$host = 'localhost';
$dbname = 'pw';
$username = 'root';
$password = '';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    // Check articles table
    $stmt = $pdo->query('SELECT COUNT(*) as count FROM pweb_articles');
    $count = $stmt->fetch()['count'];
    
    echo "Total articles in database: $count\n\n";
    
    if ($count > 0) {
        echo "Recent articles:\n";
        $stmt = $pdo->query('SELECT id, title, created_at FROM pweb_articles ORDER BY created_at DESC LIMIT 5');
        while ($row = $stmt->fetch()) {
            echo "- ID: {$row['id']}, Title: {$row['title']}, Date: {$row['created_at']}\n";
        }
    } else {
        echo "No articles found. Creating a test article...\n";
        
        $stmt = $pdo->prepare('INSERT INTO pweb_articles (title, content, created_at, updated_at) VALUES (?, ?, NOW(), NOW())');
        $stmt->execute([
            'Welcome to Perfect World Pinas',
            '<p>Welcome to our Perfect World private server! We hope you enjoy your adventure in our world.</p><p>Stay tuned for more updates and events!</p>'
        ]);
        
        echo "Test article created!\n";
    }
    
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
}