<?php

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateScheduledBroadcastsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('scheduled_broadcasts', function (Blueprint $table) {
            $table->increments('id');
            $table->text('message');
            $table->string('channel');
            $table->timestamp('scheduled_at');
            $table->boolean('is_recurring')->default(false);
            $table->integer('recurrence_interval')->nullable();
            $table->string('recurrence_unit')->nullable(); // minutes, hours, days, weeks, months
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::drop('scheduled_broadcasts');
    }
}
