<?php

use Illuminate\Database\Seeder;
use App\WikiArticle;

class WikiArticleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $articles = [
            [
                'title' => 'Getting Started Guide',
                'content' => '<h2>Welcome to Perfect World</h2>
                <p>This comprehensive guide will help you get started in the world of Perfect World. Whether you\'re a new player or returning after a break, this guide covers everything you need to know.</p>
                
                <h3>Character Creation</h3>
                <p>When creating your character, you\'ll need to choose from several classes:</p>
                <ul>
                    <li><strong>Blademaster</strong> - Melee DPS with high damage output</li>
                    <li><strong>Wizard</strong> - Ranged magic DPS with powerful spells</li>
                    <li><strong>Archer</strong> - Ranged physical DPS with bow and arrows</li>
                    <li><strong>Cleric</strong> - Support class with healing abilities</li>
                </ul>
                
                <h3>First Steps</h3>
                <p>After creating your character:</p>
                <ol>
                    <li>Complete the tutorial quests</li>
                    <li>Learn your basic skills</li>
                    <li>Explore the starting area</li>
                    <li>Join a faction for social gameplay</li>
                </ol>
                
                <blockquote>
                    <p>Remember: Take your time to learn the game mechanics. Perfect World has a rich and complex system that rewards patience and strategy.</p>
                </blockquote>',
                'excerpt' => 'A comprehensive guide for new players starting their journey in Perfect World.',
                'category' => 'guides',
                'status' => 'published',
                'author_id' => 1
            ],
            [
                'title' => 'Understanding Classes',
                'content' => '<h2>Perfect World Classes Overview</h2>
                <p>Perfect World features diverse classes, each with unique abilities and playstyles. Understanding these classes is crucial for both solo play and group dynamics.</p>
                
                <h3>Physical Classes</h3>
                <h4>Blademaster</h4>
                <p>Masters of melee combat, Blademasters excel in close-quarters battle with high damage output and decent survivability.</p>
                
                <h4>Archer</h4>
                <p>Ranged physical damage dealers who can attack from a distance with bows and crossbows.</p>
                
                <h3>Magic Classes</h3>
                <h4>Wizard</h4>
                <p>Powerful spellcasters with devastating area-of-effect abilities and high magical damage.</p>
                
                <h4>Cleric</h4>
                <p>The primary healing class, essential for group content and providing support to allies.</p>
                
                <h3>Choosing Your Class</h3>
                <p>Consider these factors when choosing:</p>
                <ul>
                    <li>Preferred playstyle (melee vs ranged)</li>
                    <li>Solo vs group focus</li>
                    <li>PvP vs PvE preference</li>
                    <li>Complexity level you\'re comfortable with</li>
                </ul>',
                'excerpt' => 'Detailed overview of all classes in Perfect World and how to choose the right one for your playstyle.',
                'category' => 'classes',
                'status' => 'published',
                'author_id' => 1
            ],
            [
                'title' => 'PvP Territory Wars Guide',
                'content' => '<h2>Territory Wars: The Ultimate PvP Experience</h2>
                <p>Territory Wars (TW) is the pinnacle of PvP content in Perfect World, where factions battle for control of territories on the world map.</p>
                
                <h3>How Territory Wars Work</h3>
                <p>Every weekend, factions can bid on territories and engage in large-scale battles:</p>
                <ul>
                    <li>Battles occur at scheduled times</li>
                    <li>Up to 80 players per faction can participate</li>
                    <li>Objective is to destroy the enemy crystal</li>
                    <li>Winners gain control of the territory</li>
                </ul>
                
                <h3>Preparation</h3>
                <p>Successful TW requires extensive preparation:</p>
                <ol>
                    <li><strong>Gear</strong> - Ensure all participants have appropriate equipment</li>
                    <li><strong>Strategy</strong> - Plan attack and defense strategies</li>
                    <li><strong>Coordination</strong> - Use voice chat for real-time communication</li>
                    <li><strong>Resources</strong> - Stock up on potions and consumables</li>
                </ol>
                
                <h3>Rewards</h3>
                <p>Controlling territories provides:</p>
                <ul>
                    <li>Weekly salary for faction members</li>
                    <li>Access to special NPCs and services</li>
                    <li>Prestige and recognition</li>
                    <li>Strategic advantages for future wars</li>
                </ul>',
                'excerpt' => 'Complete guide to Territory Wars, the ultimate PvP experience in Perfect World.',
                'category' => 'pvp',
                'status' => 'published',
                'author_id' => 1
            ],
            [
                'title' => 'Frequently Asked Questions',
                'content' => '<h2>Frequently Asked Questions</h2>
                <p>Here are answers to the most common questions new and returning players ask.</p>
                
                <h3>General Questions</h3>
                
                <h4>Q: How do I level up quickly?</h4>
                <p><strong>A:</strong> Focus on daily quests, participate in events, and join parties for dungeon runs. The experience bonus from being in a party significantly speeds up leveling.</p>
                
                <h4>Q: What should I spend my coins on?</h4>
                <p><strong>A:</strong> Prioritize upgrading your weapon and armor. Good equipment makes a huge difference in your effectiveness.</p>
                
                <h4>Q: How do I join a faction?</h4>
                <p><strong>A:</strong> Look for faction recruitment messages in world chat, or ask other players for recommendations. Most factions welcome new members.</p>
                
                <h3>Technical Questions</h3>
                
                <h4>Q: The game is running slowly, what can I do?</h4>
                <p><strong>A:</strong> Try lowering your graphics settings, closing other applications, and ensuring your drivers are up to date.</p>
                
                <h4>Q: I forgot my password, how do I reset it?</h4>
                <p><strong>A:</strong> Use the password reset feature on the login page, or contact support if you need additional help.</p>
                
                <h3>Gameplay Questions</h3>
                
                <h4>Q: When should I start doing dungeons?</h4>
                <p><strong>A:</strong> You can start doing dungeons as soon as you meet the level requirements. They\'re a great source of experience and equipment.</p>
                
                <h4>Q: Is PvP mandatory?</h4>
                <p><strong>A:</strong> No, PvP is entirely optional. You can enjoy the game focusing purely on PvE content if you prefer.</p>',
                'excerpt' => 'Answers to the most frequently asked questions about Perfect World.',
                'category' => 'faq',
                'status' => 'published',
                'author_id' => 1
            ]
        ];

        foreach ($articles as $articleData) {
            WikiArticle::create($articleData);
        }
    }
}