// Import CSS
import '../css/app.css';

// Import Alpine.js for interactive components
import Alpine from 'alpinejs';

// Start Alpine
window.Alpine = Alpine;
Alpine.start();

// Global utilities
window.formatNumber = function(fieldId, decimalPlaces) {
    const field = document.getElementById(fieldId);
    if (!field) return;
    
    const newVal = Math.round(field.value * Math.pow(10, decimalPlaces)) / Math.pow(10, decimalPlaces);
    if (parseFloat(newVal) !== parseFloat(field.value) || 
        (field.value.charAt(0) === "0" && field.value.charAt(field.value.length - 1) !== ".")) {
        field.value = newVal;
    }
};

// Toast notifications (simple implementation)
window.showToast = function(message, type = 'info') {
    const toast = document.createElement('div');
    toast.className = `fixed top-4 right-4 p-4 rounded-md shadow-lg z-50 ${
        type === 'error' ? 'bg-red-500 text-white' : 
        type === 'success' ? 'bg-green-500 text-white' : 
        'bg-blue-500 text-white'
    }`;
    toast.textContent = message;
    
    document.body.appendChild(toast);
    
    setTimeout(() => {
        toast.remove();
    }, 5000);
};

// Mobile menu toggle
document.addEventListener('DOMContentLoaded', function() {
    const mobileMenuButton = document.getElementById('mobile-menu-button');
    const mobileMenu = document.getElementById('mobile-menu');
    
    if (mobileMenuButton && mobileMenu) {
        mobileMenuButton.addEventListener('click', function() {
            mobileMenu.classList.toggle('hidden');
        });
    }
});