<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Management Language Lines
    |--------------------------------------------------------------------------
    */

    'broadcast' => [
        'title' => 'Broadcast',
        'description' => 'Send a message immediately to a player or channel',
    ],
    'mailer' => 'Mailer',
    'forbid' => 'Forbid',
    'gm' => 'Manage GM\'s',
    'chat' => 'Live Chat',
    'watch' => 'Watch',

    'edit_gm' => 'Changing :user\'s Permissions',
    'change_permissions' => 'Change Permissions',
    'gm_permissions' => [
        0 => 'Switch player\'s name and ID',
        1 => 'Turn hidden or invincible',
        2 => 'Switch online status',
        3 => 'Hide online status in wisper',
        4 => 'Teleport to player',
        5 => 'Teleport player to GM',
        6 => 'Teleport by ctrl+clicking map',
        11 => 'Show online number',
        100 => 'Ban player account/character',
        101 => 'Mute player account/character',
        102 => 'Ban trading for a player',
        103 => 'Ban selling for a player',
        104 => 'GM announcement broadcast',
        105 => 'Restart gameserver',
        200 => 'Create Monster',
        206 => 'Activate Monster Creator',
    ],

   'table' => [
       'gm' => [
           'id' => 'ID',
           'name' => 'Name',
           'actions' => 'Actions'
       ],
       'chat' => [
           'date' => 'Date',
           'user_id' => 'User ID',
           'channel' => 'Channel',
           'destination' => 'Destination',
           'message' => 'Message'
       ]
   ],

    'fields' => [
        'broadcast' => [
            'user' => 'Role ID',
            'user_desc' => 'User that you want to say the message (optional)',
            'user_placeholder' => 'Enter user ID',
            'channel' => 'Channel',
            'message' => 'Message',
            'message_placeholder' => 'Enter broadcast message'
        ],
        'mailer' => [
            'type' => 'Give To',
            'types' => [
                'list' => 'List of Players',
                'all' => 'All Players',
                'online' => 'All Online Players'
            ],
            'roles' => 'Role ID\'s',
            'roles_desc' => 'separate with (,)',
            'item_id' => 'Item ID',
            'quantity' => 'Quantity',
            'protection_type' => 'Protection Type',
            'time_limit' => 'Time Limit',
            'octet' => 'Octet',
            'mask' => 'Mask',
            'gold' => 'Gold',
            'subject' => 'Subject',
            'message' => 'Message'
        ],
        'forbid' => [
            'types' => [
                'ban_acc' => 'Ban Account',
                'ban_char' => 'Ban Character',
                'mute_acc' => 'Mute Account',
                'mute_char' => 'Mute Character'
            ],
            'type' => 'Type',
            'user_id' => 'User ID',
            'user_id_desc' => 'Account or Role ID',
            'length' => 'Length',
            'length_desc' => 'In seconds',
            'reason' => 'Reason'
        ],
        'gm' => [
            'account_id' => 'Account ID'
        ],
        'chat' => [
            'path' => 'Log Folder Path',
            'path_desc' => 'Folder path of where <b>world2.chat</b> is located.'
        ]
        ,
        // Scheduled broadcast related field labels (flat under fields)
        'scheduled_at' => 'Scheduled Date & Time',
        'scheduled_at_desc' => 'When the broadcast should be sent',
        'is_recurring' => 'Recurring Broadcast',
        'recurrence_interval' => 'Repeat Every',
        'recurrence_unit' => 'Time Unit',
        'message' => 'Message',
        'channel' => 'Channel',
        'recurring' => 'Recurring',
    ],

    'submit' => [
        'broadcast' => 'Send Message'
    ],
    'submit' => [
        'broadcast' => 'Send Message',
        'mailer' => 'Send Mail',
        'forbid' => 'Submit',
        'gm' => [
            'add' => 'Add GM',
            'save' => 'Save Permissions'
        ]
    ],
    'error' => [
        'gm' => [
            'no_user' => 'Account :acc doesn\'t exist.',
            'already_gm' => 'Account :acc is already a GM.',
        ]
    ],
    'complete' => [
        'broadcast' => 'Your message has been sent!',
        'mailer' => [
            'list' => 'Mail sent to the list players!',
            'all' => 'Mail has been sent to all players!',
            'online' => 'Mail has been sent to all online players!'
        ],
        'forbid' => [
            'ban' => [
                'account' => 'Account :user is banned for :seconds seconds!',
                'character' => 'Character :user is banned for :seconds seconds!'
            ],
            'mute' => [
                'account' => 'Account :user has been muted for :seconds seconds!',
                'character' => 'Character :user has been muted for :seconds seconds!'
            ]
        ],
        'gm' => [
            'add' => ':acc now has GM permissions!',
            'edit' => ':acc\'s permissions have been changed!',
            'remove' => ':acc\'s permissions have been revoked!',
        ]
    ],

    'buttons' => [
        'refresh' => 'Refresh'
    ],

    'channels' => [
        0 => 'Common',
        1 => 'World',
        2 => 'Party',
        3 => 'Faction',
        4 => 'Whisper',
        7 => 'Trade',
        9 => 'Broadcast',
        12 => 'Horn'
    ],
    'faction_id' => 'Faction ID: ',

    // Scheduled Broadcasts
    'scheduled_broadcasts' => 'Scheduled Broadcasts',
    'scheduled_broadcasts_description' => 'Manage automated broadcast messages',
    'create_scheduled_broadcast' => 'Create Scheduled Broadcast',
    'create_scheduled_broadcast_description' => 'Schedule a broadcast message to be sent automatically',
    'edit_scheduled_broadcast' => 'Edit Scheduled Broadcast',
    'edit_scheduled_broadcast_description' => 'Modify the scheduled broadcast settings',
    'update_scheduled_broadcast' => 'Update Scheduled Broadcast',
    'no_scheduled_broadcasts' => 'No Scheduled Broadcasts',
    'no_scheduled_broadcasts_description' => 'You haven\'t created any scheduled broadcasts yet.',
    'create_first_scheduled_broadcast' => 'Create Your First Scheduled Broadcast',
    'confirm_delete_scheduled_broadcast' => 'Are you sure you want to delete this scheduled broadcast?',

    

    'error' => [
        'recurrence_required' => 'Recurrence interval and unit are required for recurring broadcasts.',
    ],

    'complete' => [
        'scheduled_broadcast_created' => 'Scheduled broadcast has been created successfully!',
        'scheduled_broadcast_updated' => 'Scheduled broadcast has been updated successfully!',
        'scheduled_broadcast_deleted' => 'Scheduled broadcast has been deleted successfully!',
    ],

    // Auto Broadcast Settings
    'auto_broadcast_settings' => 'Auto Broadcast Settings',
    'auto_broadcast_settings_description' => 'Configure automatic broadcast message settings',
    'cron_setup_title' => 'Cron Job Setup',
    'cron_setup_description' => 'To enable automatic broadcasting, add this cron job to your server:',
    'cron_setup_note' => 'This runs every minute to check for and send scheduled broadcasts.',

    // Widget Links
    'widget_links' => 'Widget Links',
    'widget_links_description' => 'Manage links shown in the "Join Our Community" widget',

];
