@extends('admin.layouts.app')

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="dark-card">
        <div class="px-6 py-4" style="border-bottom: 1px solid #374151;">
            <h1 class="text-2xl font-bold text-white">Daily Spin Settings</h1>
            <p class="text-gray-400 mt-1">Configure the daily spin feature for your server</p>
        </div>
        <div class="p-6">
            <form method="POST" action="{{ route('admin.daily-spin.settings') }}" class="space-y-6">
                {!! csrf_field() !!}
                
                <div>
                    <label for="daily_spin_enabled" class="block text-sm font-medium text-gray-300 mb-2">
                        Enable Daily Spin <span class="text-red-400">*</span>
                    </label>
                    <select name="daily_spin_enabled" id="daily_spin_enabled" class="w-full">
                        <option value="1" {{ settings('daily_spin_enabled', true) ? 'selected' : '' }}>Enabled</option>
                        <option value="0" {{ !settings('daily_spin_enabled', true) ? 'selected' : '' }}>Disabled</option>
                    </select>
                    <p class="mt-1 text-sm text-gray-400">Enable or disable the daily spin feature for all users.</p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="daily_spin_min_reward" class="block text-sm font-medium text-gray-300 mb-2">
                            Minimum Reward <span class="text-red-400">*</span>
                        </label>
                        <input type="number" 
                               name="daily_spin_min_reward" 
                               id="daily_spin_min_reward" 
                               class="w-full" 
                               value="{{ settings('daily_spin_min_reward', 100) }}" 
                               min="1" 
                               required>
                        <p class="mt-1 text-sm text-gray-400">The minimum amount of currency a user can win from the daily spin.</p>
                    </div>

                    <div>
                        <label for="daily_spin_max_reward" class="block text-sm font-medium text-gray-300 mb-2">
                            Maximum Reward <span class="text-red-400">*</span>
                        </label>
                        <input type="number" 
                               name="daily_spin_max_reward" 
                               id="daily_spin_max_reward" 
                               class="w-full" 
                               value="{{ settings('daily_spin_max_reward', 1000) }}" 
                               min="1" 
                               required>
                        <p class="mt-1 text-sm text-gray-400">The maximum amount of currency a user can win from the daily spin.</p>
                    </div>
                </div>

                <div>
                    <label for="currency_name" class="block text-sm font-medium text-gray-300 mb-2">
                        Currency Name <span class="text-red-400">*</span>
                    </label>
                    <input type="text" 
                           id="currency_name" 
                           class="w-full" 
                           value="{{ settings('currency_name', 'coins') }}" 
                           maxlength="50" 
                           required>
                    <p class="mt-1 text-sm text-gray-400">The name of your in-game currency (e.g., coins, gold, credits).</p>
                </div>

                <div class="flex justify-end pt-6" style="border-top: 1px solid #374151;">
                    <button type="submit" class="btn-primary">Save Settings</button>
                </div>
            </form>
        </div>

<div class="grid grid-cols-1 lg:grid-cols-2 gap-6 mt-6">
    <!-- Today's Statistics -->
    <div class="dark-card">
        <div class="px-6 py-4" style="border-bottom: 1px solid #374151;">
            <h2 class="text-xl font-bold text-white flex items-center">
                <div class="w-8 h-8 bg-gradient-to-br from-blue-500 to-cyan-600 rounded-lg flex items-center justify-center mr-3">
                    <i class="fas fa-chart-bar text-white text-sm"></i>
                </div>
                Today's Statistics
            </h2>
        </div>
        <div class="p-6">
            <div class="grid grid-cols-2 gap-6">
                <div class="text-center">
                    <div class="text-3xl font-bold text-blue-400 mb-2">{{ $todaySpins }}</div>
                    <p class="text-gray-400">Spins Today</p>
                </div>
                <div class="text-center">
                    <div class="text-3xl font-bold text-green-400 mb-2">{{ number_format($todayRewards) }}</div>
                    <p class="text-gray-400">{{ settings('currency_name', 'coins') }} Given</p>
                </div>
    </div>

    <!-- All Time Statistics -->
    <div class="dark-card">
        <div class="px-6 py-4" style="border-bottom: 1px solid #374151;">
            <h2 class="text-xl font-bold text-white flex items-center">
                <div class="w-8 h-8 bg-gradient-to-br from-purple-500 to-pink-600 rounded-lg flex items-center justify-center mr-3">
                    <i class="fas fa-chart-line text-white text-sm"></i>
                </div>
                All Time Statistics
            </h2>
        </div>
        <div class="p-6">
            <div class="grid grid-cols-2 gap-6">
                <div class="text-center">
                    <div class="text-3xl font-bold text-blue-400 mb-2">{{ $totalSpins }}</div>
                    <p class="text-gray-400">Total Spins</p>
                </div>
                <div class="text-center">
                    <div class="text-3xl font-bold text-green-400 mb-2">{{ number_format($totalRewards) }}</div>
                    <p class="text-gray-400">Total {{ settings('currency_name', 'coins') }}</p>
                </div>

@if(count($recentSpins) > 0)
<div class="mt-6">
    <div class="dark-card">
        <div class="px-6 py-4" style="border-bottom: 1px solid #374151;">
            <h2 class="text-xl font-bold text-white flex items-center">
                <div class="w-8 h-8 bg-gradient-to-br from-green-500 to-emerald-600 rounded-lg flex items-center justify-center mr-3">
                    <i class="fas fa-history text-white text-sm"></i>
                </div>
                Recent Spins
            </h2>
        </div>
        <div class="p-6">
            <div class="overflow-x-auto">
                <table class="min-w-full">
                    <thead>
                        <tr>
                            <th class="text-left text-xs font-medium text-gray-300 uppercase tracking-wider py-3">User</th>
                            <th class="text-left text-xs font-medium text-gray-300 uppercase tracking-wider py-3">Reward</th>
                            <th class="text-left text-xs font-medium text-gray-300 uppercase tracking-wider py-3">Date</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($recentSpins as $spin)
                        <tr>
                            <td class="py-4 text-white font-medium">{{ $spin->username }}</td>
                            <td class="py-4">
                                <span class="badge-success">
                                    {{ number_format($spin->reward_amount) }} {{ settings('currency_name', 'coins') }}
                                </span>
                            </td>
                            <td class="py-4 text-gray-300">{{ \Carbon\Carbon::parse($spin->created_at)->format('M j, Y g:i A') }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
</div>
@endif

@endsection


@section('scripts')
<script>
document.getElementById('daily_spin_min_reward').addEventListener('input', function() {
    const minValue = parseInt(this.value);
    const maxInput = document.getElementById('daily_spin_max_reward');
    const maxValue = parseInt(maxInput.value);
    
    if (maxValue < minValue) {
        maxInput.value = minValue;
    }
});

document.getElementById('daily_spin_max_reward').addEventListener('input', function() {
    const maxValue = parseInt(this.value);
    const minInput = document.getElementById('daily_spin_min_reward');
    const minValue = parseInt(minInput.value);
    
    if (minValue > maxValue) {
        minInput.value = maxValue;
    }
});
</script>
@endsection