@extends('admin.layouts.app')

@section('content')
<div class="space-y-8">
    <!-- PayPal Settings -->
    <div class="dark-card">
        <div class="px-6 py-4" style="border-bottom: 1px solid #374151;">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-white">{{ trans('donate.paypal_title') }}</h1>
                    <p class="text-gray-400 mt-1">Configure PayPal payment integration</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-blue-600 to-indigo-600 rounded-lg flex items-center justify-center">
                    <i class="fab fa-paypal text-white"></i>
                </div>
        <div class="p-6">
            <form action="{{ url('admin/donate/paypal') }}" method="post" class="space-y-6">
                {!! csrf_field() !!}
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- PayPal Status -->
                    <div>
                        <label for="paypal_status" class="block text-sm font-medium text-gray-300 mb-2">
                            {{ trans('donate.status') }}
                        </label>
                        <select name="paypal_status" id="paypal_status" class="w-full">
                            <option value="1" {{ settings('paypal_status') ? 'selected' : '' }}>Enabled</option>
                            <option value="0" {{ !settings('paypal_status') ? 'selected' : '' }}>Disabled</option>
                        </select>
                    </div>

                    <!-- Double Donation -->
                    <div>
                        <label for="paypal_double" class="block text-sm font-medium text-gray-300 mb-2">
                            {{ trans('donate.double_donation') }}
                        </label>
                        <select name="paypal_double" id="paypal_double" class="w-full">
                            <option value="1" {{ settings('paypal_double') ? 'selected' : '' }}>Enabled</option>
                            <option value="0" {{ !settings('paypal_double') ? 'selected' : '' }}>Disabled</option>
                        </select>
                    </div>
                </div>

                <!-- Currency -->
                <div>
                    <label for="paypal_currency" class="block text-sm font-medium text-gray-300 mb-2">
                        {{ trans('donate.paypal_currency') }} <span class="text-red-400">*</span>
                    </label>
                    {!! Form::select('paypal_currency', $currencies, settings('paypal_currency'), ['class' => 'w-full', 'id' => 'paypal_currency', 'required' => true]) !!}
                </div>

                <!-- Client ID -->
                <div>
                    <label for="paypal_client_id" class="block text-sm font-medium text-gray-300 mb-2">
                        {{ trans('donate.paypal_client_id') }} <span class="text-red-400">*</span>
                    </label>
                    {!! Form::text('paypal_client_id', settings('paypal_client_id'), ['class' => 'w-full', 'id' => 'paypal_client_id', 'required' => true]) !!}
                    <p class="mt-1 text-sm text-gray-400">{!! trans('donate.paypal_client_id_desc') !!}</p>
                </div>

                <!-- Secret -->
                <div>
                    <label for="paypal_secret" class="block text-sm font-medium text-gray-300 mb-2">
                        {{ trans('donate.paypal_secret') }} <span class="text-red-400">*</span>
                    </label>
                    {!! Form::password('paypal_secret', ['class' => 'w-full', 'id' => 'paypal_secret', 'value' => settings('paypal_secret'), 'required' => true]) !!}
                </div>

                <!-- Webhook ID -->
                <div>
                    <label for="paypal_webhook_id" class="block text-sm font-medium text-gray-300 mb-2">
                        PayPal Webhook ID
                    </label>
                    {!! Form::text('paypal_webhook_id', settings('paypal_webhook_id'), ['class' => 'w-full', 'id' => 'paypal_webhook_id']) !!}
                    <p class="mt-1 text-sm text-gray-400">Optional: Webhook ID from your PayPal app for enhanced security. Leave empty to skip webhook signature verification.</p>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- Per Amount -->
                    <div>
                        <label for="paypal_per" class="block text-sm font-medium text-gray-300 mb-2">
                            {{ trans('donate.paypal_per', ['currency' => settings('paypal_currency')]) }} <span class="text-red-400">*</span>
                        </label>
                        {!! Form::input('number', 'paypal_per', settings('paypal_per'), ['class' => 'w-full', 'id' => 'paypal_per', 'step' => '0.01', 'min' => '0', 'required' => true]) !!}
                    </div>

                    <!-- Minimum Amount -->
                    <div>
                        <label for="paypal_min" class="block text-sm font-medium text-gray-300 mb-2">
                            {{ trans('donate.paypal_min', ['currency' => settings('paypal_min')]) }} <span class="text-red-400">*</span>
                        </label>
                        {!! Form::input('number', 'paypal_min', settings('paypal_min'), ['class' => 'w-full', 'id' => 'paypal_min', 'step' => '0.01', 'min' => '0', 'required' => true]) !!}
                    </div>
                </div>

                <!-- Form Actions -->
                <div class="flex justify-end pt-6" style="border-top: 1px solid #374151;">
                    <button type="submit" class="btn-primary inline-flex items-center">
                        <i class="fas fa-save mr-2"></i>{{ trans('main.save_settings') }}
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- PaymentWall Settings -->
    <div class="dark-card">
        <div class="px-6 py-4" style="border-bottom: 1px solid #374151;">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-white">{{ trans('donate.paymentwall_title') }}</h1>
                    <p class="text-gray-400 mt-1">Configure PaymentWall payment integration</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-purple-600 to-pink-600 rounded-lg flex items-center justify-center">
                    <i class="fas fa-credit-card text-white"></i>
                </div>
        <div class="p-6">
            <!-- Setup Instructions -->
            <div class="mb-6 p-4 rounded-lg" style="background-color: rgba(59, 130, 246, 0.1); border: 1px solid rgba(59, 130, 246, 0.2);">
                <h3 class="text-lg font-semibold text-blue-400 mb-3">{{ trans('donate.paymentwall_setup.title') }}</h3>
                <ol class="list-decimal list-inside space-y-2 text-gray-300">
                    <li>{{ trans('donate.paymentwall_setup.steps.1') }}</li>
                    <li>{{ trans('donate.paymentwall_setup.steps.2') }}</li>
                    <li>{{ trans('donate.paymentwall_setup.steps.3') }}</li>
                    <li>{{ trans('donate.paymentwall_setup.steps.4', ['url' => url('donate/paymentwall')]) }}</li>
                    <li>{!! trans('donate.paymentwall_setup.steps.5') !!}</li>
                </ol>
            </div>

            <form action="{{ url('admin/donate/paymentwall') }}" method="post" class="space-y-6">
                {!! csrf_field() !!}
                
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <!-- PaymentWall Status -->
                    <div>
                        <label for="paymentwall_status" class="block text-sm font-medium text-gray-300 mb-2">
                            {{ trans('donate.status') }}
                        </label>
                        <select name="paymentwall_status" id="paymentwall_status" class="w-full">
                            <option value="1" {{ settings('paymentwall_status') ? 'selected' : '' }}>Enabled</option>
                            <option value="0" {{ !settings('paymentwall_status') ? 'selected' : '' }}>Disabled</option>
                        </select>
                    </div>

                    <!-- Double Donation -->
                    <div>
                        <label for="paymentwall_double" class="block text-sm font-medium text-gray-300 mb-2">
                            {{ trans('donate.double_donation') }}
                        </label>
                        <select name="paymentwall_double" id="paymentwall_double" class="w-full">
                            <option value="1" {{ settings('paymentwall_double') ? 'selected' : '' }}>Enabled</option>
                            <option value="0" {{ !settings('paymentwall_double') ? 'selected' : '' }}>Disabled</option>
                        </select>
                    </div>
                </div>

                <!-- PaymentWall Link -->
                <div>
                    <label for="paymentwall_link" class="block text-sm font-medium text-gray-300 mb-2">
                        {{ trans('donate.paymentwall_link') }} <span class="text-red-400">*</span>
                    </label>
                    {!! Form::text('paymentwall_link', settings('paymentwall_link'), ['class' => 'w-full', 'id' => 'paymentwall_link', 'required' => true]) !!}
                </div>

                <!-- PaymentWall Key -->
                <div>
                    <label for="paymentwall_key" class="block text-sm font-medium text-gray-300 mb-2">
                        {{ trans('donate.paymentwall_key') }} <span class="text-red-400">*</span>
                    </label>
                    {!! Form::text('paymentwall_key', settings('paymentwall_key'), ['class' => 'w-full', 'id' => 'paymentwall_key', 'required' => true]) !!}
                </div>

                <!-- Form Actions -->
                <div class="flex justify-end pt-6" style="border-top: 1px solid #374151;">
                    <button type="submit" class="btn-primary inline-flex items-center">
                        <i class="fas fa-save mr-2"></i>{{ trans('main.save_settings') }}
                    </button>
                </div>
            </form>
        </div>
@endsection