@extends('admin.layouts.app')

@section('content')
<div class="space-y-8">
    <!-- Stats Cards Grid -->
    <div class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-4 gap-6">
        <div class="dark-card p-6 hover:shadow-lg transition-shadow duration-300">
            <div class="flex items-center">
                <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-users text-blue-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-400">Online Players</p>
                    <p class="text-2xl font-bold text-white">{{ $api->online ? count($api->getOnlineList()) : 0 }}</p>
                </div>
            </div>
            <div class="mt-4 text-sm text-gray-400">Live player count and quick summary.</div>
        </div>

        <div class="dark-card p-6 hover:shadow-lg transition-shadow duration-300">
            <div class="flex items-center">
                <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-user-plus text-green-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-400">Total Accounts</p>
                    <p class="text-2xl font-bold text-white">{{ number_format(DB::table('point')->count()) }}</p>
                </div>
            </div>
            <div class="mt-4 text-sm text-gray-400">Number of registered accounts.</div>
        </div>

        <div class="dark-card p-6 hover:shadow-lg transition-shadow duration-300">
            <div class="flex items-center">
                <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-user-ninja text-purple-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-400">Characters</p>
                    <p class="text-2xl font-bold text-white">{{ number_format(DB::table('pweb_ranking_players')->count()) }}</p>
                </div>
            </div>
            <div class="mt-4 text-sm text-gray-400">Total characters on your server.</div>
        </div>

        <div class="dark-card p-6 hover:shadow-lg transition-shadow duration-300">
            <div class="flex items-center">
                <div class="w-12 h-12 bg-yellow-100 rounded-lg flex items-center justify-center">
                    <i class="fas fa-flag text-yellow-600 text-xl"></i>
                </div>
                <div class="ml-4">
                    <p class="text-sm font-medium text-gray-400">Factions</p>
                    <p class="text-2xl font-bold text-white">{{ number_format(DB::table('pweb_ranking_factions')->count()) }}</p>
                </div>
            </div>
            <div class="mt-4 text-sm text-gray-400">Factions and territories overview.</div>
            </div>
        </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
        <div class="dark-card hover:shadow-lg transition-shadow duration-300">
            <div class="px-6 py-4 border-b border-gray-700">
                <h3 class="text-lg font-semibold text-white">Server Status</h3>
                <p class="text-sm text-gray-400">Monitor key services</p>
            </div>
            <div class="p-6 space-y-3">
                @foreach($api->ports() as $name => $port)
                    <div class="flex items-center justify-between p-4 rounded-lg" style="background-color: #313D4A;">
                        <div class="flex items-center space-x-3">
                            <div class="w-3 h-3 rounded-full {{ $port['open'] ? 'bg-green-500' : 'bg-red-500' }}"></div>
                            <div>
                                <p class="text-sm font-medium text-white">{{ $name }}</p>
                                <p class="text-xs text-gray-400">Port {{ $port['port'] }}</p>
                            </div>
                        </div>
                        <div class="text-right">
                            <span class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium {{ $port['open'] ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                                {{ $port['open'] ? 'Online' : 'Offline' }}
                            </span>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>

        <div class="dark-card hover:shadow-lg transition-shadow duration-300">
            <div class="px-6 py-4 border-b border-gray-700 flex items-center justify-between">
                <div>
                    <h3 class="text-lg font-semibold text-white">Monthly Activity</h3>
                    <p class="text-sm text-gray-400">Player activity over the last 12 months</p>
                </div>
                <div class="flex space-x-2">
                    <button class="px-3 py-1 text-xs font-medium text-indigo-600 bg-indigo-100 rounded-full">Overview</button>
                    <button class="px-3 py-1 text-xs font-medium text-gray-400 hover:text-white">Details</button>
                </div>
            </div>
            <div class="p-6">
                <div class="h-64 flex items-center justify-center" style="background-color: #313D4A; border-radius: 8px;">
                    <div class="text-center">
                        <i class="fas fa-chart-line text-4xl text-gray-500 mb-4"></i>
                        <p class="text-gray-400">Chart visualization would go here</p>
                        <p class="text-sm text-gray-500">Integrate with Chart.js or similar when ready</p>
                    </div>
                </div>

                <div class="grid grid-cols-3 gap-4 mt-6 text-center">
                    <div>
                        <p class="text-2xl font-bold text-white">{{ $api->online ? count($api->getOnlineList()) : 0 }}</p>
                        <p class="text-sm text-gray-400">Online Now</p>
                    </div>
                    <div>
                        <p class="text-2xl font-bold text-white">{{ number_format(DB::table('point')->count()) }}</p>
                        <p class="text-sm text-gray-400">Total Users</p>
                    </div>
                    <div>
                        <p class="text-2xl font-bold text-white">{{ number_format(DB::table('pweb_ranking_players')->count()) }}</p>
                        <p class="text-sm text-gray-400">Characters</p>
                    </div>
        </div>
    </div>

    <div class="dark-card hover:shadow-lg transition-shadow duration-300">
        <div class="px-6 py-4 border-b border-gray-700">
            <h3 class="text-lg font-semibold text-white">Quick Actions</h3>
            <p class="text-sm text-gray-400">Frequently used admin functions</p>
        </div>
        <div class="p-6">
            <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
                <a href="{{ url('admin/news') }}" class="group flex flex-col items-center p-4 rounded-lg hover:bg-gray-700 transition-all duration-200" style="background-color: #313D4A;">
                    <div class="w-12 h-12 bg-blue-100 rounded-lg flex items-center justify-center mb-3">
                        <i class="fas fa-newspaper text-blue-600 text-xl"></i>
                    </div>
                    <span class="text-sm font-medium text-white">News</span>
                </a>

                <a href="{{ url('admin/shop') }}" class="group flex flex-col items-center p-4 rounded-lg hover:bg-gray-700 transition-all duration-200" style="background-color: #313D4A;">
                    <div class="w-12 h-12 bg-green-100 rounded-lg flex items-center justify-center mb-3">
                        <i class="fas fa-shopping-cart text-green-600 text-xl"></i>
                    </div>
                    <span class="text-sm font-medium text-white">Shop</span>
                </a>

                <a href="{{ url('admin/members') }}" class="group flex flex-col items-center p-4 rounded-lg hover:bg-gray-700 transition-all duration-200" style="background-color: #313D4A;">
                    <div class="w-12 h-12 bg-purple-100 rounded-lg flex items-center justify-center mb-3">
                        <i class="fas fa-users text-purple-600 text-xl"></i>
                    </div>
                    <span class="text-sm font-medium text-white">Users</span>
                </a>

                <a href="{{ url('admin/system') }}" class="group flex flex-col items-center p-4 rounded-lg hover:bg-gray-700 transition-all duration-200" style="background-color: #313D4A;">
                    <div class="w-12 h-12 bg-orange-100 rounded-lg flex items-center justify-center mb-3">
                        <i class="fas fa-cogs text-orange-600 text-xl"></i>
                    </div>
                    <span class="text-sm font-medium text-white">Settings</span>
                </a>
            </div>
</div>

    </div>
</div>

</div>

@endsection