@if(class_exists('Breadcrumbs') && method_exists('Breadcrumbs', 'exists') && Breadcrumbs::exists())
    <nav class="flex" aria-label="Breadcrumb">
        <ol class="inline-flex items-center space-x-1 md:space-x-3">
            @php
                $breadcrumbs = Breadcrumbs::generate();
                $breadcrumbsArray = is_array($breadcrumbs) ? $breadcrumbs : $breadcrumbs->toArray();
                $totalBreadcrumbs = count($breadcrumbsArray);
            @endphp
            @foreach($breadcrumbsArray as $index => $breadcrumb)
                @if($index < $totalBreadcrumbs - 1)
                    <li class="inline-flex items-center">
                        @if(isset($breadcrumb->url) && $breadcrumb->url)
                            <a href="{{ $breadcrumb->url }}" class="inline-flex items-center text-sm font-medium text-gray-400 hover:text-white transition-colors">
                                @if($index === 0)
                                    <i class="fas fa-home mr-2"></i>
                                @endif
                                {{ $breadcrumb->title }}
                            </a>
                        @else
                            <span class="inline-flex items-center text-sm font-medium text-gray-400">
                                @if($index === 0)
                                    <i class="fas fa-home mr-2"></i>
                                @endif
                                {{ $breadcrumb->title }}
                            </span>
                        @endif
                        <i class="fas fa-chevron-right mx-2 text-gray-500 text-xs"></i>
                    </li>
                @else
                    <li aria-current="page">
                        <div class="flex items-center">
                            <span class="text-sm font-medium text-white">{{ $breadcrumb->title }}</span>
                        </div>
                    </li>
                @endif
            @endforeach
        </ol>
    </nav>
@endif