@if(session('flash_notification'))
    @foreach(session('flash_notification') as $message)
        <div class="mb-4 p-4 rounded-lg border-l-4 {{ $message['level'] == 'success' ? 'bg-green-900/50 border-green-500 text-green-100' : ($message['level'] == 'error' ? 'bg-red-900/50 border-red-500 text-red-100' : ($message['level'] == 'warning' ? 'bg-yellow-900/50 border-yellow-500 text-yellow-100' : 'bg-blue-900/50 border-blue-500 text-blue-100')) }}" 
             x-data="{ show: true }" 
             x-show="show" 
             x-transition>
            <div class="flex items-center justify-between">
                <div class="flex items-center">
                    @if($message['level'] == 'success')
                        <i class="fas fa-check-circle mr-3 text-green-400"></i>
                    @elseif($message['level'] == 'error')
                        <i class="fas fa-exclamation-circle mr-3 text-red-400"></i>
                    @elseif($message['level'] == 'warning')
                        <i class="fas fa-exclamation-triangle mr-3 text-yellow-400"></i>
                    @else
                        <i class="fas fa-info-circle mr-3 text-blue-400"></i>
                    @endif
                    <span class="font-medium">{{ $message['message'] }}</span>
                </div>
                <button @click="show = false" class="ml-4 text-gray-400 hover:text-white transition-colors">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
    @endforeach
@endif

@if($errors->any())
    <div class="mb-4 p-4 rounded-lg border-l-4 bg-red-900/50 border-red-500 text-red-100" 
         x-data="{ show: true }" 
         x-show="show" 
         x-transition>
        <div class="flex items-start justify-between">
            <div class="flex items-start">
                <i class="fas fa-exclamation-circle mr-3 text-red-400 mt-0.5"></i>
                <div>
                    <h4 class="font-medium mb-2">There were some errors with your submission:</h4>
                    <ul class="list-disc list-inside space-y-1 text-sm">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            </div>
            <button @click="show = false" class="ml-4 text-gray-400 hover:text-white transition-colors">
                <i class="fas fa-times"></i>
            </button>
        </div>
    </div>
@endif