<!-- Sidebar -->
<div class="w-64 flex-shrink-0 h-screen sticky top-16 dark-sidebar">
    <div class="flex flex-col h-full">
        <!-- Sidebar header -->
        <div class="p-6" style="border-bottom: 1px solid #313D4A;">
            <div class="flex items-center space-x-3">
                <div class="w-8 h-8 bg-gradient-to-br from-indigo-600 to-purple-600 rounded-lg flex items-center justify-center shadow-sm">
                    <i class="fas fa-gamepad text-white text-sm"></i>
                </div>
                <div>
                    <h2 class="text-lg font-bold text-white">{{ settings('server_name', 'Perfect World') }}</h2>
                    <p class="text-xs text-gray-400">Admin Panel</p>
                </div>
            </div>
        </div>

        <!-- Sidebar content -->
        <div class="flex-1 flex flex-col py-6 overflow-y-auto">
            <nav class="flex-1 px-4 space-y-1">
                <!-- Dashboard -->
                <a href="{{ url('admin/') }}" 
                   class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('admin') ? 'text-white bg-blue-600' : 'text-gray-300 hover:text-white hover:bg-gray-700' }}">
                    <i class="fas fa-tachometer-alt w-5 h-5 mr-3 {{ Request::is('admin') ? 'text-white' : 'text-gray-400 group-hover:text-gray-300' }}"></i>
                    <span>Dashboard</span>
                </a>

                <!-- System -->
                <div x-data="{ open: {{ Request::is('*system*') ? 'true' : 'false' }} }" class="space-y-1">
                    <button @click="open = !open" 
                            class="group w-full flex items-center px-3 py-2.5 text-left text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('*system*') ? 'text-white bg-blue-600' : 'text-gray-300 hover:text-white hover:bg-gray-700' }}">
                        <i class="fas fa-cogs w-5 h-5 mr-3 {{ Request::is('*system*') ? 'text-white' : 'text-gray-400 group-hover:text-gray-300' }}"></i>
                        <span class="flex-1">System</span>
                        <i class="fas fa-chevron-right transition-transform duration-200 text-xs" :class="{ 'rotate-90': open }"></i>
                    </button>
                    <div x-show="open" x-transition class="space-y-1 ml-8">
                        <a href="{{ url('admin/system/settings') }}" 
                           class="group flex items-center px-3 py-2 text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('*system/settings*') ? 'text-blue-400 bg-blue-600/10' : 'text-gray-400 hover:text-gray-300 hover:bg-gray-700' }}">
                            Settings
                        </a>
                    </div>
                </div>

                <!-- Members -->
                <a href="{{ url('admin/members') }}" 
                   class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('*members*') ? 'text-white bg-blue-600' : 'text-gray-300 hover:text-white hover:bg-gray-700' }}">
                    <i class="fas fa-users w-5 h-5 mr-3 {{ Request::is('*members*') ? 'text-white' : 'text-gray-400 group-hover:text-gray-300' }}"></i>
                    <span>Members</span>
                </a>

                <!-- News -->
                <div x-data="{ open: {{ Request::is('*news*') ? 'true' : 'false' }} }" class="space-y-1">
                    <button @click="open = !open" 
                            class="group w-full flex items-center px-3 py-2.5 text-left text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('*news*') ? 'text-white bg-blue-600' : 'text-gray-300 hover:text-white hover:bg-gray-700' }}">
                        <i class="fas fa-newspaper w-5 h-5 mr-3 {{ Request::is('*news*') ? 'text-white' : 'text-gray-400 group-hover:text-gray-300' }}"></i>
                        <span class="flex-1">News</span>
                        <i class="fas fa-chevron-right transition-transform duration-200 text-xs" :class="{ 'rotate-90': open }"></i>
                    </button>
                    <div x-show="open" x-transition class="space-y-1 ml-8">
                        <a href="{{ url('admin/news') }}" 
                           class="group flex items-center px-3 py-2 text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('admin/news') && !Request::is('*/create') && !Request::is('*/edit/*') ? 'text-blue-400 bg-blue-600/10' : 'text-gray-400 hover:text-gray-300 hover:bg-gray-700' }}">
                            View All
                        </a>
                        <a href="{{ url('admin/news/create') }}" 
                           class="group flex items-center px-3 py-2 text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('*news/create*') ? 'text-blue-400 bg-blue-600/10' : 'text-gray-400 hover:text-gray-300 hover:bg-gray-700' }}">
                            Create
                        </a>
                    </div>
                </div>

                <!-- Shop -->
                <div x-data="{ open: {{ Request::is('*shop*') ? 'true' : 'false' }} }" class="space-y-1">
                    <button @click="open = !open" 
                            class="group w-full flex items-center px-3 py-2.5 text-left text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('*shop*') ? 'text-white bg-blue-600' : 'text-gray-300 hover:text-white hover:bg-gray-700' }}">
                        <i class="fas fa-shopping-cart w-5 h-5 mr-3 {{ Request::is('*shop*') ? 'text-white' : 'text-gray-400 group-hover:text-gray-300' }}"></i>
                        <span class="flex-1">Shop</span>
                        <i class="fas fa-chevron-right transition-transform duration-200 text-xs" :class="{ 'rotate-90': open }"></i>
                    </button>
                    <div x-show="open" x-transition class="space-y-1 ml-8">
                        <a href="{{ url('admin/shop') }}" 
                           class="group flex items-center px-3 py-2 text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('admin/shop') && !Request::is('*/create') && !Request::is('*/edit/*') ? 'text-blue-400 bg-blue-600/10' : 'text-gray-400 hover:text-gray-300 hover:bg-gray-700' }}">
                            Items
                        </a>
                        <a href="{{ url('admin/shop/create') }}" 
                           class="group flex items-center px-3 py-2 text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('*shop/create*') ? 'text-blue-400 bg-blue-600/10' : 'text-gray-400 hover:text-gray-300 hover:bg-gray-700' }}">
                            Add Item
                        </a>
                        <a href="{{ url('admin/shop/settings') }}" 
                           class="group flex items-center px-3 py-2 text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('*shop/settings*') ? 'text-blue-400 bg-blue-600/10' : 'text-gray-400 hover:text-gray-300 hover:bg-gray-700' }}">
                            Settings
                        </a>
                    </div>
                </div>

                <!-- Donate -->
                <div x-data="{ open: {{ Request::is('*donate*') ? 'true' : 'false' }} }" class="space-y-1">
                    <button @click="open = !open" 
                            class="group w-full flex items-center px-3 py-2.5 text-left text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('*donate*') ? 'text-white bg-blue-600' : 'text-gray-300 hover:text-white hover:bg-gray-700' }}">
                        <i class="fas fa-heart w-5 h-5 mr-3 {{ Request::is('*donate*') ? 'text-white' : 'text-gray-400 group-hover:text-gray-300' }}"></i>
                        <span class="flex-1">Donate</span>
                        <i class="fas fa-chevron-right transition-transform duration-200 text-xs" :class="{ 'rotate-90': open }"></i>
                    </button>
                    <div x-show="open" x-transition class="space-y-1 ml-8">
                        <a href="{{ url('admin/donate/settings') }}" 
                           class="group flex items-center px-3 py-2 text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('*donate/settings*') ? 'text-blue-400 bg-blue-600/10' : 'text-gray-400 hover:text-gray-300 hover:bg-gray-700' }}">
                            Settings
                        </a>
                    </div>
                </div>

                <!-- Voucher -->
                <a href="{{ url('admin/voucher') }}" 
                   class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('*voucher*') ? 'text-white bg-blue-600' : 'text-gray-300 hover:text-white hover:bg-gray-700' }}">
                    <i class="fas fa-ticket-alt w-5 h-5 mr-3 {{ Request::is('*voucher*') ? 'text-white' : 'text-gray-400 group-hover:text-gray-300' }}"></i>
                    <span>Voucher</span>
                </a>

                <!-- Vote -->
                <a href="{{ url('admin/vote') }}" 
                   class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('*vote*') ? 'text-white bg-blue-600' : 'text-gray-300 hover:text-white hover:bg-gray-700' }}">
                    <i class="fas fa-vote-yea w-5 h-5 mr-3 {{ Request::is('*vote*') ? 'text-white' : 'text-gray-400 group-hover:text-gray-300' }}"></i>
                    <span>Vote</span>
                </a>

                <!-- Ranking -->
                <a href="{{ url('admin/ranking') }}" 
                   class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('*ranking*') ? 'text-white bg-blue-600' : 'text-gray-300 hover:text-white hover:bg-gray-700' }}">
                    <i class="fas fa-trophy w-5 h-5 mr-3 {{ Request::is('*ranking*') ? 'text-white' : 'text-gray-400 group-hover:text-gray-300' }}"></i>
                    <span>Ranking</span>
                </a>

                <!-- Daily Spin -->
                <a href="{{ url('admin/daily-spin') }}" 
                   class="group flex items-center px-3 py-2.5 text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('*daily-spin*') ? 'text-white bg-blue-600' : 'text-gray-300 hover:text-white hover:bg-gray-700' }}">
                    <i class="fas fa-sync-alt w-5 h-5 mr-3 {{ Request::is('*daily-spin*') ? 'text-white' : 'text-gray-400 group-hover:text-gray-300' }}"></i>
                    <span>Daily Spin</span>
                </a>

                <!-- Wiki -->
                <div x-data="{ open: {{ Request::is('*wiki*') ? 'true' : 'false' }} }" class="space-y-1">
                    <button @click="open = !open" 
                            class="group w-full flex items-center px-3 py-2.5 text-left text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('*wiki*') ? 'text-white bg-blue-600' : 'text-gray-300 hover:text-white hover:bg-gray-700' }}">
                        <i class="fas fa-book w-5 h-5 mr-3 {{ Request::is('*wiki*') ? 'text-white' : 'text-gray-400 group-hover:text-gray-300' }}"></i>
                        <span class="flex-1">Wiki</span>
                        <i class="fas fa-chevron-right transition-transform duration-200 text-xs" :class="{ 'rotate-90': open }"></i>
                    </button>
                    <div x-show="open" x-transition class="space-y-1 ml-8">
                        <a href="{{ url('admin/wiki') }}" 
                           class="group flex items-center px-3 py-2 text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('admin/wiki') && !Request::is('*/create') && !Request::is('*/edit/*') ? 'text-blue-400 bg-blue-600/10' : 'text-gray-400 hover:text-gray-300 hover:bg-gray-700' }}">
                            Articles
                        </a>
                        <a href="{{ url('admin/wiki/create') }}" 
                           class="group flex items-center px-3 py-2 text-sm font-medium rounded-lg transition-all duration-200 {{ Request::is('*wiki/create*') ? 'text-blue-400 bg-blue-600/10' : 'text-gray-400 hover:text-gray-300 hover:bg-gray-700' }}">
                            Create
                        </a>
                    </div>
                </div>
            </nav>
        </div>
        
        <!-- Sidebar footer -->
        <div class="flex-shrink-0 p-4" style="border-top: 1px solid #313D4A;">
            <div class="rounded-lg p-4" style="background-color: #313D4A;">
                <div class="flex items-center">
                    <div class="relative">
                        <img class="h-10 w-10 rounded-lg" src="{{ Avatar::create(strtoupper(Auth::user()->name))->toBase64() }}" alt="{{ Auth::user()->name }}">
                        <div class="absolute -bottom-1 -right-1 w-3 h-3 bg-green-500 rounded-full border-2 border-gray-800"></div>
                    </div>
                    <div class="ml-3 flex-1">
                        <p class="text-sm font-semibold text-white">{{ Auth::user()->name }}</p>
                        <p class="text-xs text-gray-400">Administrator</p>
                    </div>
                    <div class="text-gray-400 hover:text-white transition-colors cursor-pointer">
                        <i class="fas fa-ellipsis-v"></i>
                    </div>
        </div>
            </div>
        </div>