@extends('admin.layouts.app')

@section( 'content' )
    <div class="portlet light bordered">
        <div class="portlet-body form">
            <form action="{{ url( 'admin/management/broadcast' ) }}" method="post" class="space-y-6">
                {!! csrf_field() !!}
                <div class="form-body">
                    
                        {!! Form::label( 'user', trans( 'management.fields.broadcast.user' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::input( 'number', 'user', NULL, ['class' => 'form-control', 'id' => 'user'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                            <p class="mt-1 text-sm text-gray-400">{{ trans( 'management.fields.broadcast.user_desc' ) }}</p>
                        </div>
                    
                        {!! Form::label( 'channel', trans( 'management.fields.broadcast.channel' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::select( 'channel', trans( 'management.channels' ), NULL, ['class' => 'form-control', 'id' => 'channel'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                    
                        {!! Form::label( 'message', trans( 'management.fields.broadcast.message' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::text( 'message', NULL, ['class' => 'form-control', 'id' => 'message'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="flex justify-end">
                            <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold">{{ trans( 'management.submit.broadcast' ) }}</button>
                        </div>
            </form>
        </div>
@endsection