@extends('admin.layouts.app')

@section( 'content' )
    <div class="portlet light bordered">
        <div class="portlet-body form">
            <form action="{{ url( 'admin/management/chat/settings' ) }}" method="post" class="space-y-6">
                {!! csrf_field() !!}
                <div class="form-body">
                    
                        <label class="col-md-2 control-label" for="log_path">{{ trans( 'management.fields.chat.path' ) }}</label>
                        <div>
                            <input name="log_path" type="text" class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200" id="log_path" value="{{ settings( 'chat_log_path' ) }}">
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                            <p class="mt-1 text-sm text-gray-400">{!! trans( 'management.fields.chat.path_desc' ) !!}</p>
                        </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="flex justify-end">
                            <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold">{{ trans( 'main.save_settings' ) }}</button>
                        </div>
            </form>
        </div>
@endsection