@extends('admin.layouts.app')

@section( 'content' )
    <div class="portlet light bordered">
        <div class="portlet-body form">
            <form action="{{ url( 'admin/management/forbid' ) }}" method="post" class="space-y-6">
                {!! csrf_field() !!}
                <div class="form-body">
                    
                        {!! Form::label( 'type', trans( 'management.fields.forbid.type' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::select( 'type', trans( 'management.fields.forbid.types' ), NULL, ['class' => 'form-control', 'id' => 'type'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                    
                        {!! Form::label( 'user_id', trans( 'management.fields.forbid.user_id' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::input( 'number', 'user_id', NULL, ['class' => 'form-control', 'id' => 'user_id'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                            <p class="mt-1 text-sm text-gray-400"> {{ trans( 'management.fields.forbid.user_id_desc' ) }} </p>
                        </div>
                    
                        {!! Form::label( 'length', trans( 'management.fields.forbid.length' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::input( 'number', 'length', NULL, ['class' => 'form-control', 'id' => 'length'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                            <p class="mt-1 text-sm text-gray-400"> {{ trans( 'management.fields.forbid.length_desc' ) }} </p>
                        </div>
                    
                        {!! Form::label( 'reason', trans( 'management.fields.forbid.reason' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::text( 'reason', NULL, ['class' => 'form-control', 'id' => 'reason'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="flex justify-end">
                            <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold">{{ trans( 'management.submit.forbid' ) }}</button>
                        </div>
            </form>
        </div>
@endsection