@extends('admin.layouts.app')

@section( 'content' )
    <div class="portlet light bordered">
        <div class="portlet-body form">
            <form action="{{ url( 'admin/management/gm/edit/' . Request::segment( 5 ) ) }}" method="post" class="space-y-6">
                {!! csrf_field() !!}
                <div class="form-body">
                    <div class="row col-md-offset-1">
                        {{--*/ $rights = trans( 'management.gm_permissions' ) /*--}}
                        @foreach( $rights as $k => $v )
                            <div>
                                <div class="md-checkbox">
                                    <input type="hidden" name="gm_rights[{{ $k }}]" value="0">
                                    <input type="checkbox" id="right_{{ $k }}" class="md-check" name="gm_rights[{{ $k }}]" value="1" {{ isset( $user_rights[ $k ] ) ? 'checked' : NULL }}>
                                    <label for="right_{{ $k }}">
                                        <span class="inc"></span>
                                        <span class="check"></span>
                                        <span class="box"></span> {{ trans( 'management.gm_permissions.' . $k ) }} </label>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="flex justify-end">
                            <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold">{{ trans( 'management.submit.gm.save' ) }}</button>
                        </div>
            </form>
        </div>
    </div>
@endsection