@extends('admin.layouts.app')

@section( 'content' )
    <div class="portlet light bordered">
        <div class="portlet-body form">
            <form action="{{ url( 'admin/management/gm' ) }}" method="post" class="space-y-6">
                {!! csrf_field() !!}
                <div class="form-body">
                    
                        {!! Form::label( 'account_id', trans( 'management.fields.gm.account_id' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::input( 'number', 'account_id', NULL, ['class' => 'form-control', 'id' => 'account_id'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="flex justify-end">
                            <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold">{{ trans( 'management.submit.gm.add' ) }}</button>
                        </div>
            </form>
        </div>
    </div>

    <div class="dark-card">
            <div class="portlet-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                        <tr>
                            <th> {{ trans( 'management.table.gm.id' ) }} </th>
                            <th> {{ trans( 'management.table.gm.name' ) }} </th>
                            <th> {{ trans( 'management.table.gm.actions' ) }} </th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach( $gms as $gm )
                            <tr>
                                <td id="user_id"> {{ $gm->userid }} </td>
                                <td> {{ App\User::find( $gm->userid )['name'] }} </td>
                                <td>
                                    <div class="fs20">
                                        <a class="font-blue tooltips mr-md" data-placement="top" data-original-title="{{ trans( 'management.change_permissions' ) }}" href="{{ url( 'admin/management/gm/edit/' . $gm->userid ) }}"><i class="icon-settings"></i></a>
                                        <a class="font-red tooltips" data-placement="top" data-original-title="{{ trans( 'main.remove' ) }}" href="{{ url( 'admin/management/gm/remove/' . $gm->userid ) }}"><i class="icon-trash"></i></a>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
    </div>
@endsection