@extends('admin.layouts.app')

@section( 'content' )
    <div class="portlet light bordered">
        <div class="portlet-body form">
            <form action="{{ url( 'admin/management/mailer' ) }}" method="post" class="space-y-6">
                {!! csrf_field() !!}
                <div class="form-body">
                    
                        {!! Form::label( 'type', trans( 'management.fields.mailer.type' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::select( 'type', trans( 'management.fields.mailer.types' ), NULL, ['class' => 'form-control', 'id' => 'type'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                    <div class="form-group form-md-line-input" id="roles">
                        {!! Form::label( 'roles', trans( 'management.fields.mailer.roles' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::text( 'roles', NULL, ['class' => 'form-control', 'id' => 'roles'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                            <p class="mt-1 text-sm text-gray-400"> {{ trans( 'management.fields.mailer.roles_desc' ) }} </p>
                        </div>
                    
                        {!! Form::label( 'item_id', trans( 'management.fields.mailer.item_id' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::input( 'number', 'item_id', NULL, ['class' => 'form-control', 'id' => 'item_id'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                    
                        {!! Form::label( 'quantity', trans( 'management.fields.mailer.quantity' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::input( 'number', 'quantity', NULL, ['class' => 'form-control', 'id' => 'quantity'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                    <div class="form-group form-md-line-input">
                        {!! Form::label( 'protection_type', trans( 'management.fields.mailer.protection_type' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::input( 'number', 'protection_type', NULL, ['class' => 'form-control', 'id' => 'protection_type'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                    <div class="form-group form-md-line-input">
                        {!! Form::label( 'time_limit', trans( 'management.fields.mailer.time_limit' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::input( 'number', 'time_limit', NULL, ['class' => 'form-control', 'id' => 'time_limit'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                    <div class="form-group form-md-line-input">
                        {!! Form::label( 'octet', trans( 'management.fields.mailer.octet' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::text( 'octet', NULL, ['class' => 'form-control', 'id' => 'octet'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                    <div class="form-group form-md-line-input">
                        {!! Form::label( 'mask', trans( 'management.fields.mailer.mask' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::select( 'mask', $masks, NULL, ['class' => 'form-control'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                    <div class="form-group form-md-line-input">
                        {!! Form::label( 'gold', trans( 'management.fields.mailer.gold' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::input( 'number', 'gold', NULL, ['class' => 'form-control', 'id' => 'gold'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                    <div class="form-group form-md-line-input">
                        {!! Form::label( 'subject', trans( 'management.fields.mailer.subject' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::text( 'subject', NULL, ['class' => 'form-control', 'id' => 'subject'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                    <div class="form-group form-md-line-input">
                        {!! Form::label( 'message', trans( 'management.fields.mailer.message' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::textarea( 'message', NULL, ['class' => 'form-control', 'id' => 'message', 'rows' => 3] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="flex justify-end">
                            <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold">{{ trans( 'management.submit.mailer' ) }}</button>
                        </div>
            </form>
        </div>
@endsection

@section( 'footer' )
    @parent
    <script>
        $(function(){
            $("select[name=type]").change(function(){
                var value = $(this).val();
                var selDivs = $("#roles");
                if (value != "list"){
                    selDivs.hide();
                }else{
                    selDivs.show();
                }
            }).trigger("change");
        });
    </script>
@endsection