<div class="space-y-6">
    <!-- Title -->
    <div>
        <label for="title" class="block text-sm font-medium text-gray-300 mb-2">
            {{ trans('news.fields.title') }} <span class="text-red-400">*</span>
        </label>
        {!! Form::text('title', NULL, ['class' => 'w-full', 'id' => 'title', 'placeholder' => 'Enter article title...', 'required' => true]) !!}
    </div>

    <!-- Category -->
    <div>
        <label for="category" class="block text-sm font-medium text-gray-300 mb-2">
            {{ trans('news.fields.category') }} <span class="text-red-400">*</span>
        </label>
        {!! Form::select('category', $categories, NULL, ['class' => 'w-full', 'id' => 'category', 'required' => true]) !!}
    </div>

    <!-- Content -->
    <div>
        <label for="content" class="block text-sm font-medium text-gray-300 mb-2">
            {{ trans('news.fields.content') }} <span class="text-red-400">*</span>
        </label>
        {!! Form::textarea('content', NULL, ['id' => 'summernote', 'class' => 'w-full', 'rows' => '10', 'required' => true]) !!}
    </div>
</div>

<!-- Form Actions -->
<div class="flex justify-end pt-6 space-x-3" style="border-top: 1px solid #374151;">
    <a href="{{ url('admin/news') }}" class="btn-secondary inline-flex items-center">
        <i class="fas fa-times mr-2"></i>Cancel
    </a>
    {!! Form::submit($submitButtonText, ['id' => 'form_submit', 'class' => 'btn-primary inline-flex items-center']) !!}
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
<script>
$(document).ready(function() {
    $('#summernote').summernote({
        height: 400,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'italic', 'underline', 'clear']],
            ['fontname', ['fontname']],
            ['color', ['color']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['insert', ['link', 'picture', 'video']],
            ['view', ['fullscreen', 'codeview', 'help']]
        ],
        callbacks: {
            onInit: function() {
                // Apply dark theme to summernote
                $('.note-editor').css({
                    'background-color': '#1a1f2e',
                    'border': '1px solid #374151',
                    'border-radius': '8px'
                });
                $('.note-toolbar').css({
                    'background-color': '#252a3a',
                    'border-bottom': '1px solid #374151'
                });
                $('.note-editing-area .note-editable').css({
                    'background-color': '#1a1f2e',
                    'color': '#e2e8f0'
                });
            }
        }
    });

    $('#form_submit').click(function () {
        $('input[name="content"]').val($('#summernote').summernote('code'));
    });
});
</script>
@endpush