@extends('admin.layouts.app')

@section( 'content' )
    <div class="portlet light bordered">
        <div class="portlet-body form">
            <form action="{{ url( 'admin/news/settings' ) }}" method="post" class="space-y-6">
                {!! csrf_field() !!}
                <div class="form-body">
                    
                        <label class="col-md-2 control-label" for="articles_per_page">{{ trans( 'news.articles_per_page' ) }}</label>
                        <div>
                            <input name="articles_per_page" type="number" class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200" id="articles_per_page" value="{{ settings( 'news_items_per_page' ) }}">
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                            <p class="mt-1 text-sm text-gray-400">{{ trans( 'news.articles_per_page_desc' ) }}</p>
                        </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="flex justify-end">
                            <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold">{{ trans( 'main.save_settings' ) }}</button>
                        </div>
            </form>
        </div>
@endsection