@extends('admin.layouts.app')

@section( 'content' )
    <div class="portlet light bordered">
        <div class="portlet-body form">
            @if ( setupTasks() )
                <div class="dark-card">
                        <p>{{ trans( 'main.cron.info' ) }}</p>
                        <p>{{ trans( 'main.cron.job' ) }}</p>
                    </div>
                </div>
            @endif
            <form action="{{ url( 'admin/ranking/settings' ) }}" method="post" class="space-y-6">
                {!! csrf_field() !!}
                <div class="form-body">
                    
                        {!! Form::label( 'ranking_ignore_roles', trans( 'ranking.fields.ignore_roles' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::text( 'ranking_ignore_roles', settings( 'ranking_ignore_roles' ), ['class' => 'form-control', 'id' => 'ranking_ignore_roles'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                            <p class="mt-1 text-sm text-gray-400">{{ trans( 'ranking.fields.ignore_roles_desc' ) }}</p>
                        </div>
                    <div class="form-group form-md-line-input">
                        {!! Form::label( 'ranking_ignore_factions', trans( 'ranking.fields.ignore_factions' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::text( 'ranking_ignore_factions', settings( 'ranking_ignore_factions' ), ['class' => 'form-control', 'id' => 'ranking_ignore_factions'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                            <p class="mt-1 text-sm text-gray-400">{{ trans( 'ranking.fields.ignore_factions_desc' ) }}</p>
                        </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="flex justify-end">
                            <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold">{{ trans( 'main.save_settings' ) }}</button>
                        </div>
            </form>
                <div>
                    <form action="{{ url( 'admin/ranking/settings/updatePlayer' ) }}" method="get"
                          class="space-y-6">
                        {!! csrf_field() !!}
                        <div class="form-body">
                            <div class="dark-card">
                                    <p>{{ trans( 'ranking.players.content' ) }}</p>
                                    <button type="submit"
                                            class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold">{{ trans( 'ranking.players.button' ) }}</button>
                                </div>
                    </form>
                </div>
                <div>
                    <form action="{{ url( 'admin/ranking/settings/updateFaction' ) }}" method="get"
                          class="space-y-6">
                        {!! csrf_field() !!}
                        <div class="form-body">
                            <div class="dark-card">
                                    <p>{{ trans( 'ranking.factions.content' ) }}</p>
                                    <button type="submit"
                                            class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold">{{ trans( 'ranking.factions.button' ) }}</button>
                                </div>
                    </form>
                </div>
                <div>
                    <form action="{{ url( 'admin/ranking/settings/updateTerritories' ) }}" method="get"
                          class="space-y-6">
                        {!! csrf_field() !!}
                        <div class="form-body">
                            <div class="dark-card">
                                    <p>{{ trans( 'ranking.territories.content' ) }}</p>
                                    <button type="submit"
                                            class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold">{{ trans( 'ranking.territories.button' ) }}</button>
                                </div>
                    </form>
                </div>
@endsection