@extends('admin.layouts.app')

@section( 'content' )
    <div class="portlet light bordered">
        <div class="portlet-body form">
            <form action="{{ url( 'admin/services/settings' ) }}" method="post" class="space-y-6">
                {!! csrf_field() !!}
                <div class="form-body">
                    <h4 class="col-md-offset-2">{{ trans( 'services.teleport.title') }}</h4>
                    
                        {!! Form::label( 'teleport_world_tag', trans( 'services.fields.world_tag' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::input( 'number', 'teleport_world_tag', settings( 'teleport_world_tag' ), ['class' => 'form-control', 'id' => 'teleport_world_tag'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                    
                        {!! Form::label( 'teleport_x', trans( 'services.fields.x' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::input( 'number', 'teleport_x', settings( 'teleport_x' ), ['class' => 'form-control', 'id' => 'teleport_x'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                    <div class="form-group form-md-line-input">
                        {!! Form::label( 'teleport_y', trans( 'services.fields.y' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::input( 'number', 'teleport_y', settings( 'teleport_y' ), ['class' => 'form-control', 'id' => 'teleport_y'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                    <div class="form-group form-md-line-input">
                        {!! Form::label( 'teleport_z', trans( 'services.fields.z' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::input( 'number', 'teleport_z', settings( 'teleport_z' ), ['class' => 'form-control', 'id' => 'teleport_z'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                    <h4 class="col-md-offset-2">{{ trans( 'services.level_up.title') }}</h4>
                    <div class="form-group form-md-line-input">
                        {!! Form::label( 'level_cap', trans( 'services.fields.cap' ), ['class' => 'col-md-2 control-label'] ) !!}
                        <div>
                            {!! Form::input( 'number', 'level_cap', settings( 'level_up_cap' ), ['class' => 'form-control', 'id' => 'level_cap'] ) !!}
                            <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"> </div>
                <div class="form-actions">
                    <div class="row">
                        <div class="flex justify-end">
                            <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold">{{ trans( 'main.save_settings' ) }}</button>
                        </div>
            </form>
        </div>
@endsection