@extends('admin.layouts.app')

@section( 'content' )
    <form action="{{ url( 'admin/services' ) }}" method="post" class="space-y-6">
        {!! csrf_field() !!}
        @foreach( $services as $service )
            <div class="dark-card">
                    <div class="portlet-title">
                        <div class="caption"> {{ trans( 'services.' . $service->key . '.title') }} </div>
                    </div>
                    <div class="portlet-body">
                        
                            {!! Form::label( $service->key . '_enabled', trans( 'services.fields.enabled' ), ['class' => 'col-md-2 control-label'] ) !!}
                            <div>
                                {!! Form::checkbox( $service->key . '_enabled', NULL, $service->enabled, ['class' => 'make-switch', 'id' => 'enabled', 'data-size' => 'normal', 'data-on-color' => 'danger', 'data-off-color' => 'default'] ) !!}
                            </div>
                        
                            {!! Form::label( $service->key . '_price', trans( 'services.fields.price' ), ['class' => 'col-md-2 control-label'] ) !!}
                            <div>
                                {!! Form::input( 'number', $service->key . '_price', $service->price, ['class' => 'form-control'] ) !!}
                                <div class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-gray-200-focus"></div>
                                <p class="mt-1 text-sm text-gray-400">{{ trans( 'services.fields.price_desc' ) }}</p>
                            </div>
            </div>
        @endforeach
        <div>
            <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold">{{ trans( 'main.save_settings' ) }}</button>
        </div>
    </form>
@endsection