@extends('admin.layouts.app')

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="dark-card overflow-hidden">
        <div class="px-6 py-4 border-b border-gray-800">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-white">{{ trans('shop.create_item') }}</h1>
                    <p class="text-gray-400 mt-1">Add a new item to your shop</p>
                </div>
                <div class="flex items-center space-x-3">
                    <div class="w-12 h-12 bg-gradient-to-br from-green-600 to-emerald-600 rounded-lg flex items-center justify-center">
                        <i class="fas fa-plus text-white"></i>
                    </div>
                </div>
            </div>
        </div>
        <div class="p-6">
            {!! Form::model($item = new \App\ShopItem(), ['url' => route('admin.shop.index'), 'class' => '']) !!}
                @include('admin.shop.form', ['submitButtonText' => trans('shop.add_button')])
            {!! Form::close() !!}
        </div>
    </div>
</div>
@endsection