<div class="space-y-6">
    <!-- Item Name -->
    <div>
        <label for="name" class="block text-sm font-medium text-gray-300 mb-2">
            {{ trans('shop.fields.name') }} <span class="text-red-400">*</span>
        </label>
        {!! Form::text('name', NULL, ['class' => 'w-full', 'id' => 'name', 'placeholder' => 'Enter item name...', 'required' => true]) !!}
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <!-- Price -->
        <div>
            <label for="price" class="block text-sm font-medium text-gray-300 mb-2">
                {{ trans('shop.fields.price') }} <span class="text-red-400">*</span>
            </label>
            {!! Form::input('number', 'price', NULL, ['class' => 'w-full', 'id' => 'price', 'placeholder' => '0', 'min' => '0', 'required' => true]) !!}
        </div>

        <!-- Item ID -->
        <div>
            <label for="item_id" class="block text-sm font-medium text-gray-300 mb-2">
                {{ trans('shop.fields.item_id') }} <span class="text-red-400">*</span>
            </label>
            {!! Form::input('number', 'item_id', NULL, ['class' => 'w-full', 'id' => 'item_id', 'placeholder' => '0', 'min' => '0', 'required' => true]) !!}
        </div>
    </div>

    <!-- Octet -->
    <div>
        <label for="octet" class="block text-sm font-medium text-gray-300 mb-2">
            {{ trans('shop.fields.octet') }} <span class="text-red-400">*</span>
        </label>
        {!! Form::text('octet', NULL, ['class' => 'w-full', 'id' => 'octet', 'placeholder' => 'Enter octet data...', 'required' => true]) !!}
        <p class="mt-1 text-sm text-gray-400">Hexadecimal representation of the item data.</p>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <!-- Mask -->
        <div>
            <label for="mask" class="block text-sm font-medium text-gray-300 mb-2">
                {{ trans('shop.fields.mask') }} <span class="text-red-400">*</span>
            </label>
            {!! Form::select('mask', $masks, NULL, ['class' => 'w-full', 'id' => 'mask', 'required' => true]) !!}
        </div>

        <!-- Count -->
        <div>
            <label for="count" class="block text-sm font-medium text-gray-300 mb-2">
                {{ trans('shop.fields.count') }} <span class="text-red-400">*</span>
            </label>
            {!! Form::input('number', 'count', NULL, ['class' => 'w-full', 'id' => 'count', 'placeholder' => '1', 'min' => '1', 'required' => true]) !!}
        </div>

        <!-- Max Count -->
        <div>
            <label for="max_count" class="block text-sm font-medium text-gray-300 mb-2">
                {{ trans('shop.fields.max_count') }} <span class="text-red-400">*</span>
            </label>
            {!! Form::input('number', 'max_count', NULL, ['class' => 'w-full', 'id' => 'max_count', 'placeholder' => '1', 'min' => '1', 'required' => true]) !!}
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <!-- Protection Type -->
        <div>
            <label for="protection_type" class="block text-sm font-medium text-gray-300 mb-2">
                {{ trans('shop.fields.protection_type') }}
            </label>
            {!! Form::input('number', 'protection_type', NULL, ['class' => 'w-full', 'id' => 'protection_type', 'placeholder' => '0', 'min' => '0']) !!}
        </div>

        <!-- Expire Date -->
        <div>
            <label for="expire_date" class="block text-sm font-medium text-gray-300 mb-2">
                {{ trans('shop.fields.expire_date') }}
            </label>
            {!! Form::input('number', 'expire_date', NULL, ['class' => 'w-full', 'id' => 'expire_date', 'placeholder' => '0', 'min' => '0']) !!}
        </div>

        <!-- Discount -->
        <div>
            <label for="discount" class="block text-sm font-medium text-gray-300 mb-2">
                {{ trans('shop.fields.discount') }}
            </label>
            {!! Form::input('number', 'discount', NULL, ['class' => 'w-full', 'id' => 'discount', 'placeholder' => '0', 'min' => '0', 'max' => '100']) !!}
        </div>
    </div>

    <!-- Shareable -->
    <div>
        <label class="block text-sm font-medium text-gray-300 mb-3">
            {{ trans('shop.fields.shareable.title') }}
        </label>
        <div class="flex space-x-6">
            <label class="flex items-center cursor-pointer">
                {!! Form::radio('shareable', 1, NULL, ['id' => 'yes', 'class' => 'mr-2']) !!}
                <span class="text-gray-300">{{ trans('shop.fields.shareable.yes') }}</span>
            </label>
            <label class="flex items-center cursor-pointer">
                {!! Form::radio('shareable', 0, NULL, ['id' => 'no', 'class' => 'mr-2']) !!}
                <span class="text-gray-300">{{ trans('shop.fields.shareable.no') }}</span>
            </label>
        </div>
    </div>

    <!-- Description -->
    <div>
        <label for="description" class="block text-sm font-medium text-gray-300 mb-2">
            {{ trans('shop.fields.description') }}
        </label>
        {!! Form::textarea('description', NULL, ['id' => 'summernote', 'class' => 'w-full', 'rows' => '6', 'placeholder' => 'Enter item description...']) !!}
    </div>
</div>

<!-- Form Actions -->
<div class="flex justify-end pt-6 space-x-3" style="border-top: 1px solid #374151;">
    <a href="{{ url('admin/shop') }}" class="btn-secondary inline-flex items-center">
        <i class="fas fa-times mr-2"></i>Cancel
    </a>
    {!! Form::submit($submitButtonText, ['id' => 'form_submit', 'class' => 'btn-primary inline-flex items-center']) !!}
</div>

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.js"></script>
<link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-lite.min.css" rel="stylesheet">
<script>
$(document).ready(function() {
    $('#summernote').summernote({
        height: 300,
        toolbar: [
            ['style', ['style']],
            ['font', ['bold', 'italic', 'underline', 'clear']],
            ['color', ['color']],
            ['para', ['ul', 'ol', 'paragraph']],
            ['table', ['table']],
            ['insert', ['link', 'picture']],
            ['view', ['fullscreen', 'codeview', 'help']]
        ],
        callbacks: {
            onInit: function() {
                // Apply dark theme to summernote
                $('.note-editor').css({
                    'background-color': '#1a1f2e',
                    'border': '1px solid #374151',
                    'border-radius': '8px'
                });
                $('.note-toolbar').css({
                    'background-color': '#252a3a',
                    'border-bottom': '1px solid #374151'
                });
                $('.note-editing-area .note-editable').css({
                    'background-color': '#1a1f2e',
                    'color': '#e2e8f0'
                });
            }
        }
    });

    $('#form_submit').click(function () {
        $('input[name="description"]').val($('#summernote').summernote('code'));
    });
});
</script>
@endpush