@extends('admin.layouts.app')

@section('content')
<div class="max-w-4xl mx-auto">
    <div class="dark-card">
        <div class="px-6 py-4" style="border-bottom: 1px solid #374151;">
            <div class="flex items-center justify-between">
                <div>
                    <h1 class="text-2xl font-bold text-white">{{ trans('shop.settings') }}</h1>
                    <p class="text-gray-400 mt-1">Configure your shop settings and preferences</p>
                </div>
                <div class="w-12 h-12 bg-gradient-to-br from-green-600 to-emerald-600 rounded-lg flex items-center justify-center">
                    <i class="fas fa-shopping-cart text-white"></i>
                </div>
        <div class="p-6">
            <form action="{{ url('admin/shop/settings') }}" method="post" class="space-y-6">
                {!! csrf_field() !!}
                
                <!-- Items Per Page -->
                <div>
                    <label for="items_per_page" class="block text-sm font-medium text-gray-300 mb-2">
                        {{ trans('shop.items_per_page') }} <span class="text-red-400">*</span>
                    </label>
                    <input name="items_per_page" 
                           type="number" 
                           class="w-full" 
                           id="items_per_page" 
                           value="{{ settings('shop_items_per_page') }}"
                           min="1"
                           max="100"
                           required>
                    <p class="mt-1 text-sm text-gray-400">{{ trans('shop.items_per_page_desc') }}</p>
                </div>

                <!-- Form Actions -->
                <div class="flex justify-end pt-6" style="border-top: 1px solid #374151;">
                    <button type="submit" class="btn-primary inline-flex items-center">
                        <i class="fas fa-save mr-2"></i>{{ trans('main.save_settings') }}
                    </button>
                </div>
            </form>
        </div>
@endsection