@extends('admin.layouts.app')

@section( 'content' )
    @if( $items->count() > 0 )
        <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6">
            @foreach( $items as $item )
                <article x-data class="dark-card p-4 flex flex-col">
                    <div class="flex items-center space-x-4">
                        <img class="w-16 h-16 rounded-md bg-gray-800 border border-gray-700" src="{{ asset( File::exists( base_path( 'public/img/icons/' . $item->item_id . '.gif' ) ) ? 'img/icons/' . $item->item_id . '.gif' : 'img/icons/0.gif' ) }}" alt="{{ $item->name }}">
                        <div class="flex-1">
                            <h3 class="text-sm font-semibold text-gray-200" data-name>{{ $item->name }}</h3>
                            <div class="text-xs text-gray-400 mt-1">
                                @if ( $item->discount)
                                    <span class="line-through text-gray-500">{{ $item->price }}</span>
                                    <span class="ml-2 text-green-400">{{ $item->price - ( ( $item->price / 100 ) * $item->discount ) }} {{ settings( 'currency_name' ) }}</span>
                                @else
                                    <span>{{ $item->price }} {{ settings( 'currency_name' ) }}</span>
                                @endif
                            </div>
                        </div>
                    </div>

                    <div class="mt-3 text-sm text-gray-300 overflow-hidden" style="max-height: 96px;">
                        {!! $item->description !!}
                    </div>

                    @if ( !File::exists( base_path( 'public/img/icons/' . $item->item_id . '.gif' ) ) )
                        <div class="mt-3 p-3 rounded bg-red-900/30 border border-red-800 text-sm text-red-300">
                            <h4 class="font-semibold">{{ trans( 'shop.missing.title' ) }}</h4>
                            <p class="text-xs mt-1">{!! trans( 'shop.missing.body', ['path' => base_path( 'public/img/icons/' ), 'id' => $item->item_id] ) !!}</p>
                        </div>
                    @endif

                    <div class="mt-4 flex items-center justify-end space-x-2 mt-auto">
                        <a href="{{ route( 'admin.shop.edit', $item->id ) }}" class="px-3 py-1 text-sm bg-yellow-600 hover:bg-yellow-500 rounded text-white">{{ trans('main.edit') }}</a>
                        <button @click="if(confirm('{{ addslashes(trans('main.remove')) }}?')) { let el = $event.target.closest('article'); fetch('{{ route('admin.shop.destroy', $item->id) }}', { method: 'DELETE', headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Accept': 'application/json' } }).then(r => { if(r.ok) el.remove(); }); }" class="px-3 py-1 text-sm bg-red-600 hover:bg-red-500 rounded text-white">{{ trans('main.remove') }}</button>
                    </div>
                </article>
            @endforeach
        </div>
    @else
        <div class="text-center">
            <h4> {{ trans( 'main.no_results') }} </h4>
        </div>
    @endif

    <div class="mt-6 text-center">
        {!! $items->render() !!}
    </div>
@endsection

@section('footer')
    @parent
    {{-- deletion handled inline via Fetch; no extra scripts required --}}
@endsection