@extends('admin.layouts.app')

@section( 'content' )
    @if ( setupTasks() )
        <div class="dark-card">
            <p>{{ trans( 'main.cron.info' ) }}</p>
            <p>{{ trans( 'main.cron.job' ) }}</p>
        </div>
    @endif

    <div class="dark-card">
        <div class="space-y-4">
            @foreach( $sites as $site )
                <div x-data="{ open: false }" class="bg-gray-900 border border-gray-800 rounded-lg p-4">
                    <div class="flex items-center justify-between">
                        <div class="flex items-center space-x-3">
                            <button @click="open = !open" class="text-left">
                                <h3 class="text-lg font-semibold">{{ $site->name }} @if($site->double_rewards) <span class="ml-2 inline-flex items-center px-2 py-0.5 rounded text-xs font-medium bg-indigo-600 text-white">{{ trans('vote.double_rewards') }}</span> @endif</h3>
                                <p class="text-sm text-gray-400">{{ $site->link }}</p>
                            </button>
                        </div>
                        <div class="flex items-center space-x-2">
                            <a href="{{ route( 'admin.vote.edit', $site->id ) }}" class="px-3 py-1 text-sm bg-yellow-600 hover:bg-yellow-500 rounded text-white">{{ trans('main.edit') }}</a>
                            <button @click="if(confirm('{{ addslashes(trans('main.remove')) }}?')) { $el = $el || $event.target.closest('[x-data]'); fetch('{{ route('admin.vote.destroy', $site->id) }}', { method: 'DELETE', headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Accept': 'application/json' } }).then(r => { if(r.ok) $el.remove(); }); }" class="px-3 py-1 text-sm bg-red-600 hover:bg-red-500 rounded text-white">{{ trans('main.remove') }}</button>
                        </div>
                    </div>

                    <div x-show="open" x-cloak class="mt-4 border-t border-gray-800 pt-4 grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <dt class="text-sm text-gray-400">{{ trans( 'vote.fields.link' ) }}</dt>
                            <dd class="mt-1 text-sm text-gray-200">{{ $site->link }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm text-gray-400">{{ trans( 'vote.fields.limit' ) }}</dt>
                            <dd class="mt-1 text-sm text-gray-200">{{ $site->hour_limit }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm text-gray-400">{{ trans( 'vote.fields.reward' ) }}</dt>
                            <dd class="mt-1 text-sm text-gray-200">{{ $site->reward_amount }}</dd>
                        </div>
                        <div>
                            <dt class="text-sm text-gray-400">{{ trans( 'vote.fields.type.title' ) }}</dt>
                            <dd class="mt-1 text-sm text-gray-200">{{ $site->type }}</dd>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>

        <div class="mt-6 text-center">
            {!! $sites->render() !!}
        </div>
    </div>
@endsection

@section( 'footer' )
    @parent
    {{-- Deletion is handled inline via Alpine fetch; no additional JS required here --}}
@endsection