<div class="space-y-6">
    <div>
        {!! Form::label( 'code', trans( 'voucher.fields.code' ), ['class' => 'block text-sm text-gray-400'] ) !!}
        <div class="mt-1 flex items-center space-x-2">
            {!! Form::text( 'code', NULL, ['class' => 'w-full bg-gray-800 border border-gray-700 text-gray-200 rounded-md px-3 py-2', 'readonly'] ) !!}
            <button id="generate_code" type="button" class="inline-flex items-center px-3 py-2 bg-indigo-600 hover:bg-indigo-500 text-white rounded">{{ trans( 'voucher.generate' ) }}</button>
        </div>
    </div>

    <div>
        {!! Form::label( 'item_name', trans( 'voucher.fields.item_name' ), ['class' => 'block text-sm text-gray-400'] ) !!}
        {!! Form::text( 'item_name', NULL, ['class' => 'w-full bg-gray-800 border border-gray-700 text-gray-200 rounded-md px-3 py-2'] ) !!}
    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
        <div>
            {!! Form::label( 'item_id', trans( 'voucher.fields.item_id' ), ['class' => 'block text-sm text-gray-400'] ) !!}
            {!! Form::input( 'number', 'item_id', NULL, ['class' => 'w-full bg-gray-800 border border-gray-700 text-gray-200 rounded-md px-3 py-2'] ) !!}
        </div>
        <div>
            {!! Form::label( 'item_count', trans( 'voucher.fields.item_count' ), ['class' => 'block text-sm text-gray-400'] ) !!}
            {!! Form::input( 'number', 'item_count', NULL, ['class' => 'w-full bg-gray-800 border border-gray-700 text-gray-200 rounded-md px-3 py-2'] ) !!}
        </div>
        <div>
            {!! Form::label( 'item_proc_type', trans( 'voucher.fields.item_proc_type' ), ['class' => 'block text-sm text-gray-400'] ) !!}
            {!! Form::input( 'number', 'item_proc_type', NULL, ['class' => 'w-full bg-gray-800 border border-gray-700 text-gray-200 rounded-md px-3 py-2'] ) !!}
        </div>
    </div>

    <div class="flex justify-end">
        {!! Form::submit( $submitButtonText, ['id' => 'form_submit', 'class' => 'px-4 py-2 bg-green-600 hover:bg-green-500 text-white rounded-md'] ) !!}
    </div>

@section( 'footer' )
    @parent
    <script>
        document.getElementById('generate_code') && document.getElementById('generate_code').addEventListener('click', function () {
            var text = "";
            var possible = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
            for (var i = 0; i < 6; i++) text += possible.charAt(Math.floor(Math.random() * possible.length));
            var el = document.querySelector('input[name=code]'); if (el) el.value = text;
        });
    </script>
@endsection