@extends('admin.layouts.app')

@section('content')
<div class="dark-card">
    <div class="px-6 py-4 flex items-center justify-between" style="border-bottom: 1px solid #374151;">
        <div>
            <h1 class="text-2xl font-bold text-white">{{ trans('wiki.manage_wiki') }}</h1>
            <p class="text-gray-400 mt-1">Manage your wiki articles and content</p>
        </div>
        <div>
            <a href="{{ url('admin/wiki/create') }}" class="btn-primary inline-flex items-center">
                <i class="fas fa-plus mr-2"></i>{{ trans('wiki.add_article') }}
            </a>
        </div>
    </div>
    <div class="p-6">
        @if($articles->count() > 0)
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-700">
                    <thead class="bg-gray-700">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">{{ trans('wiki.article_title') }}</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">{{ trans('wiki.article_category') }}</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">{{ trans('wiki.article_status') }}</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">{{ trans('wiki.views') }}</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">{{ trans('wiki.author') }}</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">{{ trans('wiki.published') }}</th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">{{ trans('main.actions') }}</th>
                        </tr>
                    </thead>
                    <tbody class="bg-gray-800 divide-y divide-gray-700">
                        @foreach($articles as $article)
                            <tr class="hover:bg-gray-700 transition-colors">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div>
                                        <div class="text-sm font-medium text-white">{{ $article->title }}</div>
                                        <div class="text-sm text-gray-400">{{ $article->slug }}</div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="badge-info">
                                        {{ $article->category_name }}
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    @if($article->status == 'published')
                                        <span class="badge-success">
                                            {{ trans('wiki.status_published') }}
                                        </span>
                                    @else
                                        <span class="badge-warning">
                                            {{ trans('wiki.status_draft') }}
                                        </span>
                                    @endif
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                                    <i class="fas fa-eye mr-1"></i>{{ number_format($article->views) }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                                    {{ $article->author->name ?? 'Admin' }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                                    {{ $article->created_at->format('M d, Y') }}
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <div class="flex space-x-2">
                                        <a href="{{ url('wiki/' . $article->slug) }}" 
                                           target="_blank"
                                           class="text-blue-400 hover:text-blue-300 transition-colors" 
                                           title="{{ trans('main.view') }}">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ url('admin/wiki/edit/' . $article->id) }}" 
                                           class="text-yellow-400 hover:text-yellow-300 transition-colors" 
                                           title="{{ trans('wiki.edit_article') }}">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="{{ url('admin/wiki/delete/' . $article->id) }}" 
                                           class="text-red-400 hover:text-red-300 transition-colors" 
                                           onclick="return confirm('{{ trans('wiki.confirm_delete') }}')"
                                           title="{{ trans('wiki.delete_article') }}">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            @if($articles->hasPages())
                <div class="mt-6 flex justify-center">
                    {{ $articles->links() }}
                </div>
            @endif
        @else
            <div class="text-center py-12">
                <div class="w-24 h-24 mx-auto mb-6 bg-gray-700 rounded-full flex items-center justify-center">
                    <i class="fas fa-book text-4xl text-gray-400"></i>
                </div>
                <h3 class="text-xl font-semibold text-white mb-2">{{ trans('wiki.no_results') }}</h3>
                <p class="text-gray-400 mb-6">{{ trans('wiki.no_results_description') }}</p>
                <a href="{{ url('admin/wiki/create') }}" class="btn-primary inline-flex items-center">
                    <i class="fas fa-plus mr-2"></i>{{ trans('wiki.create_article') }}
                </a>
            </div>
        @endif
    </div>
</div>
@endsection