@extends('admin.layouts.app')

@section('content')
    <div class="space-y-4">
        <h2 class="text-xl font-semibold">{{ trans('daily-spin.settings') }}</h2>
        <div class="text-sm text-gray-400">{{ settings('server_name') }}</div>

        <div class="dark-card p-4">
            <div class="grid grid-cols-3 gap-4 mb-4">
                <div class="bg-gray-800 p-4 rounded">
                    <div class="text-sm text-gray-400">{{ trans('daily-spin.todays_spins') }}</div>
                    <div class="text-2xl font-semibold">{{ $todaySpins }}</div>
                </div>
                <div class="bg-gray-800 p-4 rounded">
                    <div class="text-sm text-gray-400">{{ trans('daily-spin.todays_rewards') }}</div>
                    <div class="text-2xl font-semibold">{{ $todayRewards }}</div>
                </div>
                <div class="bg-gray-800 p-4 rounded">
                    <div class="text-sm text-gray-400">{{ trans('daily-spin.total_spins') }}</div>
                    <div class="text-2xl font-semibold">{{ $totalSpins }}</div>
                </div>
            </div>

            <div class="mb-4">
                <h3 class="font-semibold">{{ trans('daily-spin.recent_spins') }}</h3>
                <div class="mt-2 space-y-2">
                    @forelse($recentSpins as $spin)
                        <div class="flex items-center justify-between bg-gray-900 p-3 rounded">
                            <div>
                                <div class="font-semibold">{{ $spin->username }}</div>
                                <div class="text-sm text-gray-400">{{ $spin->created_at }}</div>
                            </div>
                            <div class="text-right">
                                <div class="text-lg font-semibold">{{ $spin->reward_amount }}</div>
                            </div>
                        </div>
                    @empty
                        <div class="text-sm text-gray-500">{{ trans('daily-spin.no_recent_spins') }}</div>
                    @endforelse
                </div>
            </div>

            <form action="{{ url('admin/daily-spin/settings') }}" method="post" class="space-y-4">
                {!! csrf_field() !!}

                <div class="grid grid-cols-2 gap-4">
                    <div>
                        <label class="block text-sm text-gray-300">{{ trans('daily-spin.enabled') }}</label>
                        <select name="daily_spin_enabled" class="mt-1 block w-48 bg-gray-800 border border-gray-700 rounded-md px-3 py-2 text-gray-200">
                            <option value="1" {{ settings('daily_spin_enabled') ? 'selected' : '' }}>{{ trans('daily-spin.enabled') }}</option>
                            <option value="0" {{ !settings('daily_spin_enabled') ? 'selected' : '' }}>{{ trans('daily-spin.disabled') }}</option>
                        </select>
                    </div>

                    <div>
                        <label class="block text-sm text-gray-300">{{ trans('daily-spin.currency_name') }}</label>
                        <input name="currency_name" type="text" value="{{ old('currency_name', settings('currency_name')) }}" class="mt-1 block w-48 bg-gray-800 border border-gray-700 rounded-md px-3 py-2 text-gray-200">
                    </div>

                    <div>
                        <label class="block text-sm text-gray-300">{{ trans('daily-spin.min_reward') }}</label>
                        <input name="daily_spin_min_reward" type="number" min="1" value="{{ old('daily_spin_min_reward', settings('daily_spin_min_reward')) }}" class="mt-1 block w-48 bg-gray-800 border border-gray-700 rounded-md px-3 py-2 text-gray-200">
                    </div>

                    <div>
                        <label class="block text-sm text-gray-300">{{ trans('daily-spin.max_reward') }}</label>
                        <input name="daily_spin_max_reward" type="number" min="1" value="{{ old('daily_spin_max_reward', settings('daily_spin_max_reward')) }}" class="mt-1 block w-48 bg-gray-800 border border-gray-700 rounded-md px-3 py-2 text-gray-200">
                    </div>
                </div>

                <div class="flex justify-end">
                    <button type="submit" class="px-4 py-2 bg-indigo-600 hover:bg-indigo-500 text-white rounded">{{ trans('daily-spin.save_settings') }}</button>
                </div>
            </form>
        </div>
    </div>

@endsection
