<!DOCTYPE html>
<html lang="en" class="h-full">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>{{ pagetitle()->get() }}</title>
    <meta name="description" content="">
    <meta name="author" content="">
    
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <!-- Styles -->
    <link href="{{ asset('build/app.css') }}" rel="stylesheet">
    
    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <!-- Favicon -->
    <link rel="shortcut icon" href="{{ asset('favicon.ico') }}">
    
    <style>
        /* TailAdmin Dark Theme */
        * {
            box-sizing: border-box;
        }
        
        html, body {
            background-color: #1C2434 !important;
            color: #DEE4EE !important;
            font-family: 'Inter', sans-serif !important;
        }
        
        /* Custom scrollbar */
        ::-webkit-scrollbar {
            width: 4px;
            height: 4px;
        }
        ::-webkit-scrollbar-track {
            background: #24303F;
        }
        ::-webkit-scrollbar-thumb {
            background: #3C50E0;
            border-radius: 2px;
        }
        ::-webkit-scrollbar-thumb:hover {
            background: #5A6ACF;
        }
        
        /* Override any light backgrounds */
        .bg-white { background-color: #24303F !important; }
        .bg-gray-50 { background-color: #1C2434 !important; }
        .bg-gray-100 { background-color: #24303F !important; }
        .bg-gray-200 { background-color: #313D4A !important; }
        .text-gray-900 { color: #DEE4EE !important; }
        .text-gray-800 { color: #A9B8C7 !important; }
        .text-gray-700 { color: #8A99AF !important; }
        
        /* Dark card style - TailAdmin */
        .dark-card {
            background: #24303F !important;
            border: 1px solid #313D4A !important;
            border-radius: 10px !important;
            box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05) !important;
        }
        
        /* Sidebar dark style - TailAdmin */
        .dark-sidebar {
            background: #1C2434 !important;
            border-right: 1px solid #313D4A !important;
        }
        
        /* Navigation dark style - TailAdmin */
        .dark-nav {
            background: #24303F !important;
            backdrop-filter: blur(10px) !important;
            border-bottom: 1px solid #313D4A !important;
        }
        
        /* Form Elements - TailAdmin Theme */
        input[type="text"],
        input[type="email"],
        input[type="password"],
        input[type="number"],
        input[type="url"],
        input[type="search"],
        input[type="tel"],
        input[type="date"],
        input[type="datetime-local"],
        input[type="time"],
        textarea,
        select {
            background-color: #24303F !important;
            border: 1.5px solid #313D4A !important;
            color: #DEE4EE !important;
            border-radius: 7px !important;
            padding: 12px 16px !important;
            font-size: 14px !important;
            transition: all 0.2s ease !important;
            font-weight: 500 !important;
        }
        
        input[type="text"]:focus,
        input[type="email"]:focus,
        input[type="password"]:focus,
        input[type="number"]:focus,
        input[type="url"]:focus,
        input[type="search"]:focus,
        input[type="tel"]:focus,
        input[type="date"]:focus,
        input[type="datetime-local"]:focus,
        input[type="time"]:focus,
        textarea:focus,
        select:focus {
            outline: none !important;
            border-color: #3C50E0 !important;
            box-shadow: 0 0 0 4px rgba(60, 80, 224, 0.1) !important;
            background-color: #24303F !important;
        }
        
        /* Placeholder text */
        input::placeholder,
        textarea::placeholder {
            color: #8A99AF !important;
        }
        
        /* Select dropdown */
        select option {
            background-color: #24303F !important;
            color: #DEE4EE !important;
        }
        
        /* Buttons - TailAdmin Theme */
        .btn,
        button,
        input[type="submit"],
        input[type="button"] {
            border-radius: 7px !important;
            font-weight: 600 !important;
            font-size: 14px !important;
            padding: 12px 20px !important;
            transition: all 0.2s ease !important;
            border: none !important;
            cursor: pointer !important;
        }
        
        /* Primary Button - TailAdmin Blue */
        .btn-primary,
        .bg-blue-500,
        .bg-blue-600,
        .bg-indigo-500,
        .bg-indigo-600 {
            background: #3C50E0 !important;
            color: white !important;
        }
        
        .btn-primary:hover,
        .bg-blue-500:hover,
        .bg-blue-600:hover,
        .bg-indigo-500:hover,
        .bg-indigo-600:hover {
            background: #5A6ACF !important;
            transform: translateY(-1px) !important;
            box-shadow: 0 4px 15px rgba(60, 80, 224, 0.4) !important;
        }
        
        /* Success Button */
        .btn-success,
        .bg-green-500,
        .bg-green-600 {
            background: #10B981 !important;
            color: white !important;
        }
        
        .btn-success:hover,
        .bg-green-500:hover,
        .bg-green-600:hover {
            background: #059669 !important;
            transform: translateY(-1px) !important;
            box-shadow: 0 4px 15px rgba(16, 185, 129, 0.4) !important;
        }
        
        /* Danger Button */
        .btn-danger,
        .bg-red-500,
        .bg-red-600 {
            background: #DC3545 !important;
            color: white !important;
        }
        
        .btn-danger:hover,
        .bg-red-500:hover,
        .bg-red-600:hover {
            background: #C82333 !important;
            transform: translateY(-1px) !important;
            box-shadow: 0 4px 15px rgba(220, 53, 69, 0.4) !important;
        }
            color: #8b5cf6 !important;
        }
        
        /* Pagination */
        .pagination {
            background-color: #1a1f2e !important;
            border: 1px solid #374151 !important;
            border-radius: 8px !important;
        }
        
        .pagination a,
        .pagination span {
            background-color: #252a3a !important;
            color: #e2e8f0 !important;
            border: 1px solid #374151 !important;
            padding: 8px 12px !important;
        }
        
        .pagination a:hover {
            background-color: #374151 !important;
            color: #6366f1 !important;
        }
        
        /* Modal/Dialog */
        .modal,
        .dialog {
            background-color: #1a1f2e !important;
            border: 1px solid #374151 !important;
            border-radius: 12px !important;
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.5) !important;
        }
        
        /* Breadcrumbs */
        .breadcrumb {
            background-color: transparent !important;
        }
        
        .breadcrumb a {
            color: #9ca3af !important;
        }
        
        .breadcrumb a:hover {
            color: #e2e8f0 !important;
        }
        
        /* Code blocks */
        code,
        pre {
            background-color: #252a3a !important;
            color: #e2e8f0 !important;
            border: 1px solid #374151 !important;
            border-radius: 6px !important;
            padding: 8px 12px !important;
        }
        
        /* Progress bars */
        .progress {
            background-color: #374151 !important;
            border-radius: 8px !important;
            overflow: hidden !important;
        }
        
        .progress-bar {
            background: linear-gradient(135deg, #6366f1, #8b5cf6) !important;
        }
    </style>
    
    @stack('styles')
</head>
<body class="h-full antialiased" style="background-color: #1C2434 !important; color: #DEE4EE !important;" x-data="{ sidebarOpen: false, mobileMenuOpen: false }">
    <div class="min-h-full" style="background-color: #1C2434 !important;">
        <!-- Navigation -->
        <nav class="dark-nav fixed top-0 left-0 right-0 z-50">
            <div class="mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex h-16 items-center justify-between">
                    <!-- Logo -->
                    <div class="flex items-center">
                        <div class="flex-shrink-0">
                            <a href="{{ url('admin') }}" class="flex items-center group">
                                <div class="w-10 h-10 bg-gradient-to-br from-indigo-600 to-purple-600 rounded-lg flex items-center justify-center mr-3 shadow-lg hover:shadow-indigo-500/25 transition-all duration-300">
                                    <i class="fas fa-cog text-white text-lg"></i>
                                </div>
                                <div class="flex flex-col">
                                    <span class="text-lg font-bold text-white group-hover:text-indigo-300 transition-colors">
                                        {{ settings('server_name', 'Perfect World') }}
                                    </span>
                                    <span class="text-xs text-indigo-400 font-medium -mt-1">Admin Control Panel</span>
                                </div>
                            </a>
                        </div>
                    </div>

                    <!-- Desktop Navigation -->
                    <div class="hidden md:flex items-center space-x-4">
                        <!-- Quick Actions -->
                        <a href="{{ url('/') }}" target="_blank" 
                           class="flex items-center text-gray-400 hover:text-white px-4 py-2 rounded-lg text-sm font-medium transition-all duration-300"
                           style="background-color: rgba(55, 65, 81, 0.3);">
                            <i class="fas fa-external-link-alt mr-2"></i>View Site
                        </a>
                        
                        <!-- Server Status -->
                        <div class="flex items-center px-3 py-2 rounded-lg" style="background-color: rgba(34, 197, 94, 0.1); border: 1px solid rgba(34, 197, 94, 0.3);">
                            <div class="w-2 h-2 bg-green-400 rounded-full animate-pulse mr-2"></div>
                            <span class="text-green-300 text-xs font-medium">Online</span>
                        </div>
                    </div>

                    <!-- Right side -->
                    <div class="hidden md:block">
                        <div class="ml-4 flex items-center md:ml-6 space-x-4">
                            <!-- Language Selector -->
                            <div class="relative" x-data="{ open: false }">
                                <button @click="open = !open" 
                                        class="flex items-center text-gray-400 hover:text-white px-4 py-2 rounded-lg text-sm font-medium transition-all duration-300"
                                        style="background-color: rgba(55, 65, 81, 0.3);">
                                    <i class="fas fa-globe mr-2 text-indigo-400"></i>
                                    {{ strtoupper(App::getLocale()) }}
                                    <i class="fas fa-chevron-down ml-2 text-xs transition-transform duration-300" :class="{ 'rotate-180': open }"></i>
                                </button>
                                
                                <div x-show="open" @click.away="open = false" 
                                     x-transition:enter="transition ease-out duration-200"
                                     x-transition:enter-start="transform opacity-0 scale-95 translate-y-2"
                                     x-transition:enter-end="transform opacity-100 scale-100 translate-y-0"
                                     x-transition:leave="transition ease-in duration-150"
                                     x-transition:leave-start="transform opacity-100 scale-100 translate-y-0"
                                     x-transition:leave-end="transform opacity-0 scale-95 translate-y-2"
                                     class="absolute right-0 mt-3 w-48 rounded-lg shadow-2xl py-2 z-50 dark-card">
                                    @foreach($languages as $language)
                                        <a href="{{ Request::url() . '?language=' . $language }}" 
                                           class="flex items-center px-4 py-2 text-sm text-gray-400 hover:text-white transition-colors {{ App::getLocale() == $language ? 'text-indigo-400' : '' }}"
                                           style="background-color: {{ App::getLocale() == $language ? 'rgba(99, 102, 241, 0.1)' : 'transparent' }};">
                                            @if($language == 'en')
                                                <img src="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAiIGhlaWdodD0iMTUiIHZpZXdCb3g9IjAgMCAyMCAxNSIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3Qgd2lkdGg9IjIwIiBoZWlnaHQ9IjE1IiBmaWxsPSIjMDEyMTY5Ii8+CjxwYXRoIGQ9Ik0wIDBoMjB2MS4yNUgwVjB6bTAgMi41aDIwdjEuMjVIMFYyLjV6bTAgMi41aDIwdjEuMjVIMFY1em0wIDIuNWgyMHYxLjI1SDBWNy41em0wIDIuNWgyMHYxLjI1SDBWMTB6bTAgMi41aDIwVjE1SDBWMTIuNXoiIGZpbGw9IndoaXRlIi8+CjxwYXRoIGQ9Ik0wIDBoOHY3LjVIMFYweiIgZmlsbD0iIzAxMjE2OSIvPgo8cGF0aCBkPSJNMSAxaDZ2MUgxVjF6bTAgMmg2djFIMVYzem0wIDJoNnYxSDFWNXoiIGZpbGw9IndoaXRlIi8+CjxwYXRoIGQ9Ik0wIDcuNWgyMHYxLjI1SDBWNy41eiIgZmlsbD0iI0ZGMDAwMCIvPgo8cGF0aCBkPSJNOC41IDBoMS4yNXY3LjVIOC41VjB6IiBmaWxsPSIjRkYwMDAwIi8+CjxwYXRoIGQ9Ik0wIDBoMjBMMTAgNy41IDAgMHoiIGZpbGw9IiNGRjAwMDAiIG9wYWNpdHk9IjAuMyIvPgo8cGF0aCBkPSJNMjAgMEwwIDE1aDIwTDEwIDcuNSAyMCAweiIgZmlsbD0iI0ZGMDAwMCIgb3BhY2l0eT0iMC4zIi8+Cjwvc3ZnPgo=" alt="EN" class="w-5 h-4 mr-3 rounded">
                                            @elseif($language == 'id')
                                                <img src="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAiIGhlaWdodD0iMTUiIHZpZXdCb3g9IjAgMCAyMCAxNSIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3Qgd2lkdGg9IjIwIiBoZWlnaHQ9IjcuNSIgZmlsbD0iI0ZGMDAwMCIvPgo8cmVjdCB5PSI3LjUiIHdpZHRoPSIyMCIgaGVpZ2h0PSI3LjUiIGZpbGw9IndoaXRlIi8+Cjwvc3ZnPgo=" alt="ID" class="w-5 h-4 mr-3 rounded">
                                            @elseif($language == 'pt')
                                                <img src="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAiIGhlaWdodD0iMTUiIHZpZXdCb3g9IjAgMCAyMCAxNSIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3Qgd2lkdGg9IjIwIiBoZWlnaHQ9IjE1IiBmaWxsPSIjRkYwMDAwIi8+CjxyZWN0IHdpZHRoPSI4IiBoZWlnaHQ9IjE1IiBmaWxsPSIjMDA2NjAwIi8+CjxjaXJjbGUgY3g9IjgiIGN5PSI3LjUiIHI9IjMiIGZpbGw9IiNGRkRGMDAiLz4KPGNpcmNsZSBjeD0iOCIgY3k9IjcuNSIgcj0iMi41IiBmaWxsPSIjMDA1MkZGIi8+CjxyZWN0IHg9IjYuNSIgeT0iNiIgd2lkdGg9IjMiIGhlaWdodD0iMyIgZmlsbD0iI0ZGMDAwMCIvPgo8L3N2Zz4K" alt="PT" class="w-5 h-4 mr-3 rounded">
                                            @elseif($language == 'ru')
                                                <img src="data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjAiIGhlaWdodD0iMTUiIHZpZXdCb3g9IjAgMCAyMCAxNSIgZmlsbD0ibm9uZSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4KPHJlY3Qgd2lkdGg9IjIwIiBoZWlnaHQ9IjUiIGZpbGw9IndoaXRlIi8+CjxyZWN0IHk9IjUiIHdpZHRoPSIyMCIgaGVpZ2h0PSI1IiBmaWxsPSIjMDA1MkZGIi8+CjxyZWN0IHk9IjEwIiB3aWR0aD0iMjAiIGhlaWdodD0iNSIgZmlsbD0iI0ZGMDAwMCIvPgo8L3N2Zz4K" alt="RU" class="w-5 h-4 mr-3 rounded">
                                            @else
                                                <div class="w-5 h-4 mr-3 bg-gray-600 rounded flex items-center justify-center text-xs font-bold text-gray-300">
                                                    {{ strtoupper($language) }}
                                                </div>
                                            @endif
                                            {{ trans('language.' . $language) }}
                                        </a>
                                    @endforeach
                                </div>
                            </div>

                            <!-- Profile dropdown -->
                            <div class="relative" x-data="{ open: false }">
                                <button @click="open = !open" 
                                        class="flex items-center px-4 py-2 rounded-lg text-sm font-medium transition-all duration-300 focus:outline-none"
                                        style="background-color: rgba(55, 65, 81, 0.3);">
                                    <img class="h-8 w-8 rounded-lg border-2 border-indigo-500/30" src="{{ Avatar::create(strtoupper(Auth::user()->name))->toBase64() }}" alt="{{ Auth::user()->name }}">
                                    <div class="ml-3 text-left">
                                        <div class="text-white font-semibold">{{ Auth::user()->name }}</div>
                                        <div class="text-indigo-300 text-xs">Administrator</div>
                                    </div>
                                    <i class="fas fa-chevron-down ml-3 text-xs text-gray-400 transition-transform duration-300" :class="{ 'rotate-180': open }"></i>
                                </button>
                                
                                <div x-show="open" @click.away="open = false" 
                                     x-transition:enter="transition ease-out duration-200"
                                     x-transition:enter-start="transform opacity-0 scale-95 translate-y-2"
                                     x-transition:enter-end="transform opacity-100 scale-100 translate-y-0"
                                     x-transition:leave="transition ease-in duration-150"
                                     x-transition:leave-start="transform opacity-100 scale-100 translate-y-0"
                                     x-transition:leave-end="transform opacity-0 scale-95 translate-y-2"
                                     class="absolute right-0 mt-3 w-56 rounded-lg shadow-2xl py-2 z-50 dark-card">
                                    <div class="px-4 py-3" style="border-bottom: 1px solid #374151;">
                                        <p class="text-sm font-medium text-white">Signed in as</p>
                                        <p class="text-sm text-indigo-300 font-semibold">{{ Auth::user()->name }}</p>
                                    </div>
                                    <a href="{{ url('/') }}" target="_blank" 
                                       class="flex items-center px-4 py-3 text-sm text-gray-400 hover:text-white transition-all duration-300">
                                        <i class="fas fa-home mr-3 text-blue-400"></i>{{ trans('main.site') }}
                                    </a>
                                    <a href="{{ url('auth/logout') }}" 
                                       class="flex items-center px-4 py-3 text-sm text-gray-400 hover:text-white transition-all duration-300">
                                        <i class="fas fa-sign-out-alt mr-3 text-red-400"></i>{{ trans('main.logout') }}
                                    </a>
                                </div>
                    </div>

                    <!-- Mobile menu button -->
                    <div class="md:hidden">
                        <button @click="mobileMenuOpen = !mobileMenuOpen" 
                                class="inline-flex items-center justify-center rounded-lg p-2 text-gray-400 hover:text-white focus:outline-none transition-all duration-300"
                                style="background-color: rgba(55, 65, 81, 0.3);">
                            <i class="fas fa-bars"></i>
                        </button>
                    </div>
        </nav>

        <div class="flex pt-16" style="background-color: #0f1419 !important;">
            <!-- Sidebar -->
            @include('admin.layouts.sidebar')

            <!-- Main content -->
            <div class="flex-1 flex flex-col overflow-hidden">
                <!-- Breadcrumbs -->
                <div class="px-6 py-4 dark-card" style="border-bottom: 1px solid #313D4A; border-radius: 0;">
                    @include('admin.layouts.breadcrumbs')
                </div>

                <!-- Page content -->
                <main class="flex-1 overflow-x-hidden overflow-y-auto p-6" style="background-color: #1C2434 !important;">
                    <!-- Flash messages -->
                    @include('admin.layouts.flash')

                    <!-- Unified content wrapper: main column + optional right sidebar -->
                    <div class="w-full mx-auto">
                        <div>
                            <!-- Primary content card (pages render inside this) -->
                            <div class="dark-card p-6">
                                @yield('content')
                            </div>
                        </div>
                    </div>
                </main>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script>
        // Add some modern interactions
        document.addEventListener('DOMContentLoaded', function() {
            // Add smooth scrolling
            document.documentElement.style.scrollBehavior = 'smooth';
            
            // Add loading states for buttons
            document.querySelectorAll('button, .btn').forEach(button => {
                button.addEventListener('click', function() {
                    if (!this.disabled) {
                        this.style.transform = 'scale(0.98)';
                        setTimeout(() => {
                            this.style.transform = '';
                        }, 150);
                    }
                });
            });
            
            // Add hover effects for cards
            document.querySelectorAll('.modern-card').forEach(card => {
                card.addEventListener('mouseenter', function() {
                    this.style.transform = 'translateY(-2px)';
                    this.style.boxShadow = '0 20px 40px rgba(0, 0, 0, 0.3)';
                });
                
                card.addEventListener('mouseleave', function() {
                    this.style.transform = '';
                    this.style.boxShadow = '';
                });
            });
        });
    </script>
    
    <!-- jQuery: required by legacy WYSIWYG plugins like Summernote used in some admin forms -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    @stack('scripts')

    <script src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
    <script src="/node_modules/flowbite/dist/flowbite.min.js" defer></script>
</body>
</html>