<aside class="w-64 dark-sidebar hidden md:flex flex-col h-screen sticky top-16">
    <!-- Header -->
    <div class="p-6 border-b border-gray-800">
        <div class="flex items-center space-x-3">
            <div class="w-8 h-8 bg-gradient-to-br from-indigo-600 to-purple-600 rounded-lg flex items-center justify-center shadow-sm">
                <i class="fas fa-gamepad text-white text-sm"></i>
            </div>
            <div>
                <h2 class="text-lg font-bold text-white">{{ settings('server_name', 'Perfect World') }}</h2>
                <p class="text-xs text-gray-400">Admin Panel</p>
            </div>
        </div>
    </div>

    <!-- Menu -->
    <nav class="flex-1 overflow-y-auto px-3 py-4 space-y-4">
        {{-- get menu config --}}
        {{--*/ $menus = config('menu.admin') /*--}}
        @foreach($menus as $name => $menu)
            @if(!is_array($menu))
                <a href="{{ url('admin/' . ($menu == 'dashboard' ? '' : $name)) }}" class="flex items-center px-3 py-2 rounded-lg text-sm hover:bg-gray-800 {{ Request::is('*' . $name . '*') || ($menu == 'dashboard' && Request::is('admin')) ? 'bg-blue-600 text-white' : 'text-gray-300' }}">
                    <span class="flex-1">{{ is_array(trans('menu.' . ($menu == 'dashboard' ? 'dashboard' : $name))) ? (array_key_exists('title', trans('menu.' . ($menu == 'dashboard' ? 'dashboard' : $name))) ? trans('menu.' . ($menu == 'dashboard' ? 'dashboard' : $name))['title'] : current(trans('menu.' . ($menu == 'dashboard' ? 'dashboard' : $name)))) : trans('menu.' . ($menu == 'dashboard' ? 'dashboard' : $name)) }}</span>
                </a>
            @else
                <div>
                    <div class="px-3 py-1 text-xs text-gray-400 uppercase font-semibold">{{ is_array(trans('menu.' . $name . '.title')) ? (array_key_exists('title', trans('menu.' . $name . '.title')) ? trans('menu.' . $name . '.title')['title'] : current(trans('menu.' . $name . '.title'))) : trans('menu.' . $name . '.title') }}</div>
                    <div class="mt-1 space-y-1">
                        @foreach($menu as $k => $v)
                            @unless($k === 'application')
                                <a href="{{ url('admin/' . $name . '/' . (is_numeric($k) ? $v : $k)) }}" class="block px-3 py-2 rounded-lg text-sm hover:bg-gray-800 text-gray-300">{{ is_array(trans('menu.' . $name . '.' . (is_numeric($k) ? $v : $k))) ? (array_key_exists('title', trans('menu.' . $name . '.' . (is_numeric($k) ? $v : $k))) ? trans('menu.' . $name . '.' . (is_numeric($k) ? $v : $k))['title'] : current(trans('menu.' . $name . '.' . (is_numeric($k) ? $v : $k)))) : trans('menu.' . $name . '.' . (is_numeric($k) ? $v : $k)) }}</a>
                            @endunless
                        @endforeach
                    </div>
                </div>
            @endif
        @endforeach
    </nav>

    <!-- Footer -->
    <div class="p-4 border-t border-gray-800">
        <div class="rounded-lg p-3 bg-gray-800 flex items-center">
            <div class="relative">
                <img class="h-10 w-10 rounded-lg" src="{{ Avatar::create(strtoupper(Auth::user()->name))->toBase64() }}" alt="{{ Auth::user()->name }}">
                <div class="absolute -bottom-1 -right-1 w-3 h-3 bg-green-500 rounded-full border-2 border-gray-800"></div>
            </div>
            <div class="ml-3 flex-1">
                <p class="text-sm font-semibold text-white">{{ Auth::user()->name }}</p>
                <p class="text-xs text-gray-400">Administrator</p>
            </div>
            <div class="text-gray-400 hover:text-white transition-colors cursor-pointer">
                <i class="fas fa-ellipsis-v"></i>
            </div>
        </div>
    </div>
</aside>