@extends('admin.layouts.app')

@section('title', trans('management.auto_broadcast_settings'))

@section('content')
<div class="space-y-6">
    <!-- Auto Broadcast Settings -->
    <div class="dark-card">
        <div class="px-6 py-4 border-b border-gray-700">
            <h1 class="text-2xl font-bold text-white">{{ trans('management.auto_broadcast_settings') }}</h1>
            <p class="text-gray-400 mt-1">{{ trans('management.auto_broadcast_settings_description') }}</p>
        </div>

        <div class="p-6">
            <form action="{{ url('admin/management/auto-broadcast-settings') }}" method="post" class="space-y-6">
                {!! csrf_field() !!}

                <!-- Enable/Disable Auto Broadcasts -->
                <div class="flex items-center">
                    <input type="hidden" name="scheduled_broadcasts_enabled" value="0">
                    <input type="checkbox"
                           id="scheduled_broadcasts_enabled"
                           name="scheduled_broadcasts_enabled"
                           value="1"
                           {{ settings('scheduled_broadcasts_enabled', true) ? 'checked' : '' }}
                           class="rounded border-gray-700 bg-gray-800 text-indigo-600 focus:ring-indigo-500 focus:ring-2">
                    <label for="scheduled_broadcasts_enabled" class="ml-3 text-sm font-medium text-gray-300">
                        {{ trans('management.scheduled_broadcasts_enabled') }}
                    </label>
                </div>
                <p class="text-sm text-gray-400">{{ trans('management.scheduled_broadcasts_enabled_desc') }}</p>

                <!-- Cron Setup Instructions -->
                <div class="bg-gray-800/50 border border-gray-700 rounded-lg p-4">
                    <h4 class="text-sm font-semibold text-gray-300 mb-2">{{ trans('management.cron_setup_title') }}</h4>
                    <p class="text-sm text-gray-400 mb-3">{{ trans('management.cron_setup_description') }}</p>
                    <div class="bg-gray-900 rounded p-3 font-mono text-xs text-green-400 border border-gray-600">
                        <div class="mb-2">Unix / Linux (cron):</div>
                        <pre class="m-0">* * * * * cd {{ base_path() }} && {{ PHP_BINARY }} {{ addslashes(base_path('artisan')) }} broadcasts:process >> /dev/null 2>&1</pre>
                        <div class="mt-2">Windows (Task Scheduler):</div>
                        <pre class="m-0">* * * * * {{ PHP_BINARY }} {{ addslashes(base_path('artisan')) }} broadcasts:process >> NUL 2>&1</pre>
                    </div>
                    <p class="text-xs text-gray-500 mt-2">{{ trans('management.cron_setup_note') }}</p>
                </div>

                <!-- Submit Button -->
                <div class="flex justify-end pt-4 border-t border-gray-700">
                    <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold transition-colors">
                        <i class="fas fa-save mr-2"></i>
                        {{ trans('main.save_settings') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection