@extends('admin.layouts.app')

@section('content')
<div class="max-w-4xl mx-auto space-y-6">
    <div class="dark-card">
        <div class="px-6 py-4 border-b border-gray-700">
            <h1 class="text-2xl font-bold text-white">{{ trans('management.broadcast.title') }}</h1>
            <p class="text-gray-400 mt-1">{{ trans('management.broadcast.description') }}</p>
        </div>

        <div class="p-6">
            <form action="{{ url('admin/management/broadcast') }}" method="post" class="space-y-6">
                {!! csrf_field() !!}

                <!-- User ID -->
                <div>
                    <label for="user" class="block text-sm font-medium text-gray-300 mb-2">
                        {{ trans('management.fields.broadcast.user') }} <span class="text-red-400">*</span>
                    </label>
              <input type="number"
                  id="user"
                  name="user"
                  class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent"
                  placeholder="{{ trans('management.fields.broadcast.user_placeholder') }}"
                  required>
                    <p class="mt-1 text-sm text-gray-400">{{ trans('management.fields.broadcast.user_desc') }}</p>
                </div>

                <!-- Channel -->
                <div>
                    <label for="channel" class="block text-sm font-medium text-gray-300 mb-2">
                        {{ trans('management.fields.broadcast.channel') }} <span class="text-red-400">*</span>
                    </label>
                    <select id="channel"
                            name="channel"
                            class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-white focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent"
                            required>
                        @foreach(trans('management.channels') as $key => $name)
                            <option value="{{ $key }}">{{ $name }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Message -->
                <div>
                    <label for="message" class="block text-sm font-medium text-gray-300 mb-2">
                        {{ trans('management.fields.broadcast.message') }} <span class="text-red-400">*</span>
                    </label>
                    <textarea id="message"
                              name="message"
                              rows="4"
                              class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent"
                              placeholder="{{ trans('management.fields.broadcast.message_placeholder') }}"
                              required></textarea>
                </div>

                <!-- Submit Button -->
                <div class="flex justify-end pt-4 border-t border-gray-700">
                    <button type="submit" class="inline-flex items-center px-6 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold transition-colors">
                        <i class="fas fa-broadcast-tower mr-2"></i>
                        {{ trans('management.submit.broadcast') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection