@extends('admin.layouts.app')

@section('content')
<div class="max-w-4xl mx-auto space-y-6">
    <div class="dark-card">
        <div class="px-6 py-4 border-b border-gray-700">
            <h1 class="text-2xl font-bold text-white">{{ trans('management.broadcast.title') }}</h1>
            <p class="text-gray-400 mt-1">{{ trans('management.broadcast.description') }}</p>
        </div>

        <div class="p-6">
            {{-- Debug: show resolved translations for troubleshooting --}}
            <div class="mb-4 p-3 bg-gray-900 text-sm text-gray-300 rounded">
                <strong>Debug translations:</strong>
                <div>user: {{ trans('management.fields.broadcast.user') }}</div>
                <div>user_desc: {{ trans('management.fields.broadcast.user_desc') }}</div>
                <div>message: {{ trans('management.fields.broadcast.message') }}</div>
            </div>
            @include('admin.layouts.flash')

            @if ($errors->any())
                <div class="mb-4">
                    <div class="text-red-400 font-semibold">{{ trans('main.errors') }}</div>
                    <ul class="mt-2 list-disc list-inside text-sm text-red-300">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ url('admin/management/scheduled-broadcasts/create') }}" method="POST" class="space-y-6">
                @include('admin.management.scheduled-broadcasts._form')
            </form>
            <div class="mt-6 p-4 bg-gray-900 rounded text-sm text-gray-300">
                <strong>{{ trans('management.scheduled.cron_title', [], 'en') }}</strong>
                <p class="mt-2">{{ trans('management.scheduled.cron_description', [], 'en') }}</p>
                <pre class="mt-3 bg-gray-800 p-3 rounded text-xs overflow-auto">
{{ PHP_BINARY }} {{ addslashes(base_path('artisan')) }} schedule:run >> /dev/null 2>&1
                </pre>
            </div>
        </div>
    </div>
</div>