@extends('admin.layouts.app')

@section('content')
<div class="max-w-4xl mx-auto space-y-6">
    <div class="dark-card">
        <div class="px-6 py-4 border-b border-gray-700">
            <h1 class="text-2xl font-bold text-white">{{ trans('management.edit_scheduled_broadcast') }}</h1>
            <p class="text-gray-400 mt-1">{{ trans('management.edit_scheduled_broadcast_description') }}</p>
        </div>

        <div class="p-6">
            <form action="/admin/management/scheduled-broadcasts/edit/{{ $broadcast->id }}" method="post" class="space-y-6">
                {!! csrf_field() !!}

                <!-- User ID -->
                <div>
                    <label for="user" class="block text-sm font-medium text-gray-300 mb-2">
                        {{ trans('management.fields.broadcast.user') }} <span class="text-red-400">*</span>
                    </label>
                    <input type="number"
                           id="user"
                           name="user"
                           value="{{ $broadcast->user }}"
                           class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent"
                           placeholder="Enter user ID"
                           required>
                    <p class="mt-1 text-sm text-gray-400">{{ trans('management.fields.broadcast.user_desc') }}</p>
                </div>

                <!-- Channel -->
                <div>
                    <label for="channel" class="block text-sm font-medium text-gray-300 mb-2">
                        {{ trans('management.fields.broadcast.channel') }} <span class="text-red-400">*</span>
                    </label>
                    <select id="channel"
                            name="channel"
                            class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-white focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent"
                            required>
                        @foreach(trans('management.channels') as $key => $name)
                            <option value="{{ $key }}" {{ $broadcast->channel == $key ? 'selected' : '' }}>{{ $name }}</option>
                        @endforeach
                    </select>
                </div>

                <!-- Message -->
                <div>
                    <label for="message" class="block text-sm font-medium text-gray-300 mb-2">
                        {{ trans('management.fields.broadcast.message') }} <span class="text-red-400">*</span>
                    </label>
                    <textarea id="message"
                              name="message"
                              rows="4"
                              class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent"
                              placeholder="Enter broadcast message"
                              required>{{ $broadcast->message }}</textarea>
                </div>

                <!-- Scheduled At -->
                <div>
                    <label for="scheduled_at" class="block text-sm font-medium text-gray-300 mb-2">
                        {{ trans('management.fields.scheduled_at') }} <span class="text-red-400">*</span>
                    </label>
                    <input type="datetime-local"
                           id="scheduled_at"
                           name="scheduled_at"
                           value="{{ $broadcast->scheduled_at->format('Y-m-d\TH:i') }}"
                           class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent"
                           required>
                    <p class="mt-1 text-sm text-gray-400">{{ trans('management.fields.scheduled_at_desc') }}</p>
                </div>

                <!-- Recurring Options -->
                <div class="space-y-4">
                    <div class="flex items-center">
                        <input type="checkbox"
                               id="is_recurring"
                               name="is_recurring"
                               value="1"
                               {{ $broadcast->is_recurring ? 'checked' : '' }}
                               class="rounded border-gray-700 bg-gray-800 text-indigo-600 focus:ring-indigo-500 focus:ring-2">
                        <label for="is_recurring" class="ml-2 text-sm font-medium text-gray-300">
                            {{ trans('management.fields.is_recurring') }}
                        </label>
                    </div>

                    <div id="recurrence-options" class="space-y-4 ml-6 {{ $broadcast->is_recurring ? '' : 'hidden' }}">
                        <div class="grid grid-cols-2 gap-4">
                            <div>
                                <label for="recurrence_interval" class="block text-sm font-medium text-gray-300 mb-2">
                                    {{ trans('management.fields.recurrence_interval') }}
                                </label>
                                <input type="number"
                                       id="recurrence_interval"
                                       name="recurrence_interval"
                                       min="1"
                                       value="{{ $broadcast->recurrence_interval }}"
                                       class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent"
                                       {{ $broadcast->is_recurring ? 'required' : '' }}>
                            </div>
                            <div>
                                <label for="recurrence_unit" class="block text-sm font-medium text-gray-300 mb-2">
                                    {{ trans('management.fields.recurrence_unit') }}
                                </label>
                                <select id="recurrence_unit"
                                        name="recurrence_unit"
                                        class="w-full py-2 px-3 rounded-md bg-gray-800 border border-gray-700 text-white focus:outline-none focus:ring-2 focus:ring-indigo-500 focus:border-transparent"
                                        {{ $broadcast->is_recurring ? 'required' : '' }}>
                                    <option value="minutes" {{ $broadcast->recurrence_unit == 'minutes' ? 'selected' : '' }}>{{ trans('time.minutes') }}</option>
                                    <option value="hours" {{ $broadcast->recurrence_unit == 'hours' ? 'selected' : '' }}>{{ trans('time.hours') }}</option>
                                    <option value="days" {{ $broadcast->recurrence_unit == 'days' ? 'selected' : '' }}>{{ trans('time.days') }}</option>
                                    <option value="weeks" {{ $broadcast->recurrence_unit == 'weeks' ? 'selected' : '' }}>{{ trans('time.weeks') }}</option>
                                    <option value="months" {{ $broadcast->recurrence_unit == 'months' ? 'selected' : '' }}>{{ trans('time.months') }}</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="flex justify-between pt-4 border-t border-gray-700">
                    <a href="/admin/management/scheduled-broadcasts" class="inline-flex items-center px-4 py-2 rounded-md bg-gray-600 hover:bg-gray-500 text-white font-semibold transition-colors">
                        <i class="fas fa-arrow-left mr-2"></i>
                        {{ trans('main.back') }}
                    </a>
                    <button type="submit" class="inline-flex items-center px-6 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold transition-colors">
                        <i class="fas fa-save mr-2"></i>
                        {{ trans('management.update_scheduled_broadcast') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
document.getElementById('is_recurring').addEventListener('change', function() {
    const recurrenceOptions = document.getElementById('recurrence-options');
    const intervalInput = document.getElementById('recurrence_interval');
    const unitSelect = document.getElementById('recurrence_unit');

    if (this.checked) {
        recurrenceOptions.classList.remove('hidden');
        intervalInput.required = true;
        unitSelect.required = true;
    } else {
        recurrenceOptions.classList.add('hidden');
        intervalInput.required = false;
        unitSelect.required = false;
    }
});
</script>
@endsection