@extends('admin.layouts.app')

@section('content')
<div class="grid grid-cols-2 gap-6">
    <div>
    <div class="dark-card">
        <div class="px-6 py-4 border-b border-gray-700 flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-white">{{ trans('management.scheduled_broadcasts') }}</h1>
                <p class="text-gray-400 mt-1">{{ trans('management.scheduled_broadcasts_description') }}</p>
            </div>
            <a href="/admin/management/scheduled-broadcasts/create" onclick="window.location.href='/admin/management/scheduled-broadcasts/create'; return false;" role="button" tabindex="0" class="js-nav inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold transition-colors">
                <i class="fas fa-plus mr-2"></i>
                {{ trans('management.create_scheduled_broadcast') }}
            </a>
        </div>

        <div class="p-6">
            @if($broadcasts->count() > 0)
                <div class="overflow-x-auto">
                    <table class="w-full table-auto">
                        <thead>
                            <tr class="border-b border-gray-700">
                                <th class="text-left py-3 px-4 text-gray-300 font-semibold">{{ trans('management.fields.broadcast.user') }}</th>
                                <th class="text-left py-3 px-4 text-gray-300 font-semibold">{{ trans('management.fields.message') }}</th>
                                <th class="text-left py-3 px-4 text-gray-300 font-semibold">{{ trans('management.fields.channel') }}</th>
                                <th class="text-left py-3 px-4 text-gray-300 font-semibold">{{ trans('management.fields.scheduled_at') }}</th>
                                <th class="text-left py-3 px-4 text-gray-300 font-semibold">{{ trans('management.fields.recurring') }}</th>
                                <th class="text-center py-3 px-4 text-gray-300 font-semibold">{{ trans('main.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-700">
                            @foreach($broadcasts as $broadcast)
                                <tr class="hover:bg-gray-800/50">
                                    <td class="py-4 px-4 text-gray-300 font-mono text-sm">
                                        {{ $broadcast->user }}
                                    </td>
                                    <td class="py-4 px-4 text-gray-300 max-w-xs truncate" title="{{ $broadcast->message }}">
                                        {{ Str::limit($broadcast->message, 50) }}
                                    </td>
                                    <td class="py-4 px-4 text-gray-300">
                                        {{ trans('management.channels')[$broadcast->channel] ?? $broadcast->channel }}
                                    </td>
                                    <td class="py-4 px-4 text-gray-300">
                                        {{ $broadcast->scheduled_at->format('M j, Y g:i A') }}
                                    </td>
                                    <td class="py-4 px-4 text-gray-300">
                                        @if($broadcast->is_recurring)
                                            <span class="inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-green-900 text-green-300">
                                                <i class="fas fa-redo mr-1"></i>
                                                {{ $broadcast->recurrence_interval }} {{ $broadcast->recurrence_unit }}
                                            </span>
                                        @else
                                            <span class="text-gray-500">{{ trans('main.no') }}</span>
                                        @endif
                                    </td>
                                    <td class="py-4 px-4 text-center">
                                        <div class="flex justify-center space-x-2">
                                            <a href="{{ url('admin/management/scheduled-broadcasts/edit/' . $broadcast->id) }}"
                                               class="inline-flex items-center px-3 py-1 rounded-md bg-blue-600 hover:bg-blue-500 text-white text-sm font-medium transition-colors">
                                                <i class="fas fa-edit mr-1"></i>
                                                {{ trans('main.edit') }}
                                            </a>
                                            <a href="{{ url('admin/management/scheduled-broadcasts/delete/' . $broadcast->id) }}"
                                               class="inline-flex items-center px-3 py-1 rounded-md bg-red-600 hover:bg-red-500 text-white text-sm font-medium transition-colors"
                                               onclick="return confirm('{{ trans('management.confirm_delete_scheduled_broadcast') }}')">
                                                <i class="fas fa-trash mr-1"></i>
                                                {{ trans('main.delete') }}
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <!-- Pagination -->
                <div class="mt-6">
                    {{ $broadcasts->links() }}
                </div>
            @else
                <div class="text-center py-12">
                    <i class="fas fa-broadcast-tower text-6xl text-gray-600 mb-4"></i>
                    <h3 class="text-xl font-semibold text-gray-300 mb-2">{{ trans('management.no_scheduled_broadcasts') }}</h3>
                    <p class="text-gray-500 mb-6">{{ trans('management.no_scheduled_broadcasts_description') }}</p>
                    <a href="{{ url('admin/management/scheduled-broadcasts/create') }}" class="inline-flex items-center px-6 py-3 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold transition-colors">
                        <i class="fas fa-plus mr-2"></i>
                        {{ trans('management.create_first_scheduled_broadcast') }}
                    </a>
                </div>
            @endif
        </div>
    </div>
        <div class="mb-6">
            <h3 class="text-lg font-semibold mb-2">{{ trans('management.create_scheduled_broadcast') }}</h3>
            <form action="{{ url('admin/management/scheduled-broadcasts/create') }}" method="POST">
                @include('admin.management.scheduled-broadcasts._form')
            </form>
        </div>

        <div class="text-sm text-gray-400 bg-gray-900 p-4 rounded">
            <strong>{{ trans('management.cron_setup_title') }}</strong>
            <p class="mt-1">{{ trans('management.cron_setup_description') }}</p>
            <div class="mt-2">
                <div class="text-xs text-gray-300 font-medium">Unix / Linux (cron)</div>
                <pre class="bg-gray-900 p-3 mt-1 rounded">* * * * * {{ PHP_BINARY }} {{ addslashes(base_path('artisan')) }} broadcasts:process >> /dev/null 2>&1</pre>
            </div>
            <div class="mt-2">
                <div class="text-xs text-gray-300 font-medium">Windows (Task Scheduler)</div>
                <pre class="bg-gray-900 p-3 mt-1 rounded">* * * * * {{ PHP_BINARY }} {{ addslashes(base_path('artisan')) }} broadcasts:process >> NUL 2>&1</pre>
            </div>
            <p class="mt-2 text-xs text-gray-500">{{ trans('management.cron_setup_note') }}</p>
        </div>
    </div>
</div>
</div>
@endsection