@extends('admin.layouts.app')

@section('content')
<div class="max-w-4xl mx-auto space-y-6">
    <div class="dark-card">
        <div class="px-6 py-4 border-b border-gray-700">
            <h1 class="text-2xl font-bold text-white">{{ trans('management.widget_links') }}</h1>
            <p class="text-gray-400 mt-1">{{ trans('management.widget_links_description') }}</p>
        </div>

        <div class="p-6">
            @include('admin.layouts.flash')

            <form action="{{ url('admin/management/widget-links') }}" method="POST">
                {!! csrf_field() !!}

                <div id="links-list" class="space-y-3">
                    @foreach($links as $i => $link)
                        <div class="bg-gray-800 p-3 rounded flex items-start space-x-3 link-row">
                            <input type="text" name="links[{{ $i }}][label]" value="{{ $link['label'] }}" placeholder="Label" class="flex-1 rounded bg-gray-900 border border-gray-700 p-2 text-sm" />
                            <input type="text" name="links[{{ $i }}][url]" value="{{ $link['url'] }}" placeholder="https://..." class="flex-1 rounded bg-gray-900 border border-gray-700 p-2 text-sm" />
                            <input type="text" name="links[{{ $i }}][icon]" value="{{ $link['icon'] ?? '' }}" placeholder="icon (optional)" class="w-32 rounded bg-gray-900 border border-gray-700 p-2 text-sm" />
                            <button type="button" class="remove-link inline-flex items-center px-3 py-1 rounded bg-red-600 hover:bg-red-500 text-white">Remove</button>
                        </div>
                    @endforeach
                </div>

                <div class="mt-4">
                    <button id="add-link" type="button" class="inline-flex items-center px-4 py-2 rounded bg-indigo-600 hover:bg-indigo-500 text-white">
                        <i class="fas fa-plus mr-2"></i> Add Link
                    </button>
                </div>

                <div class="flex justify-end pt-4 border-t border-gray-700">
                    <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold transition-colors">
                        <i class="fas fa-save mr-2"></i>
                        {{ trans('main.save_settings') }}
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    (function(){
        const container = document.getElementById('links-list');
        const addBtn = document.getElementById('add-link');

        function reindex() {
            Array.from(container.querySelectorAll('.link-row')).forEach((row, idx) => {
                row.querySelectorAll('input').forEach(input => {
                    const name = input.getAttribute('name');
                    const newName = name.replace(/links\[\d+\]/, 'links['+idx+']');
                    input.setAttribute('name', newName);
                });
            });
        }

        addBtn.addEventListener('click', function(){
            const idx = container.querySelectorAll('.link-row').length;
            const div = document.createElement('div');
            div.className = 'bg-gray-800 p-3 rounded flex items-start space-x-3 link-row';
            div.innerHTML = `
                <input type="text" name="links[${idx}][label]" placeholder="Label" class="flex-1 rounded bg-gray-900 border border-gray-700 p-2 text-sm" />
                <input type="text" name="links[${idx}][url]" placeholder="https://..." class="flex-1 rounded bg-gray-900 border border-gray-700 p-2 text-sm" />
                <input type="text" name="links[${idx}][icon]" placeholder="icon (optional)" class="w-32 rounded bg-gray-900 border border-gray-700 p-2 text-sm" />
                <button type="button" class="remove-link inline-flex items-center px-3 py-1 rounded bg-red-600 hover:bg-red-500 text-white">Remove</button>
            `;
            container.appendChild(div);
            reindex();
        });

        document.addEventListener('click', function(e){
            if (e.target && e.target.classList.contains('remove-link')) {
                e.target.closest('.link-row').remove();
                reindex();
            }
        });
    })();
</script>
@endsection
