@extends('admin.layouts.app')

@section('content')
<div class="space-y-4">
    <div class="flex items-center justify-between">
        <h2 class="text-lg font-semibold">{{ trans('members.manage') }}</h2>
        <a href="{{ url('admin/members/create') }}" class="btn btn-primary">{{ trans('members.add_button') ?? 'Create Member' }}</a>
    </div>

    <div class="dark-card p-4">
        <form method="GET" action="{{ url('admin/members') }}" class="flex items-center space-x-2">
            <input type="search" name="q" placeholder="{{ trans('members.fields.search.placeholder') }}" value="{{ request('q') }}" class="flex-1" />
            <button class="btn btn-primary" type="submit">{{ trans('main.search') ?? 'Search' }}</button>
        </form>
    </div>

    <div class="dark-card overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-700">
            <thead class="bg-gray-800">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">ID</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Username</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Email</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Created</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-400 uppercase">Actions</th>
                </tr>
            </thead>
            <tbody class="bg-transparent divide-y divide-gray-700">
                @php $users = isset($users) ? $users : collect([]); @endphp

                @forelse($users as $user)
                    <tr>
                        <td class="px-6 py-4 text-sm text-gray-300">{{ $user->id }}</td>
                        <td class="px-6 py-4 text-sm text-white">{{ $user->name }}</td>
                        <td class="px-6 py-4 text-sm text-gray-300">{{ $user->email }}</td>
                        <td class="px-6 py-4 text-sm text-gray-300">{{ optional($user->created_at)->format('Y-m-d') }}</td>
                        <td class="px-6 py-4 text-sm text-gray-300">
                            <div class="flex items-center space-x-2">
                                <a href="{{ url('admin/members/' . $user->id) }}" class="px-3 py-1 rounded bg-gray-800 text-sm text-white">{{ trans('main.view') }}</a>
                                <a href="{{ url('admin/members/' . $user->id . '/edit') }}" class="px-3 py-1 rounded bg-gray-800 text-sm text-white">{{ trans('main.edit') }}</a>
                                <form method="POST" action="{{ url('admin/members/' . $user->id . '/ban') }}" x-data @submit.prevent="if(confirm('Ban this user?')) $event.target.submit()">
                                    {{ csrf_field() }}
                                    <button type="submit" class="px-3 py-1 rounded bg-yellow-600 text-sm text-white">Ban</button>
                                </form>
                                <form method="POST" action="{{ url('admin/members/' . $user->id) }}" x-data @submit.prevent="if(confirm('Delete this user?')) $event.target.submit()">
                                    {{ method_field('DELETE') }}
                                    {{ csrf_field() }}
                                    <button type="submit" class="px-3 py-1 rounded bg-red-600 text-sm text-white">{{ trans('main.remove') }}</button>
                                </form>
                            </div>
                        </td>
                    </tr>
                @empty
                    <tr>
                        <td colspan="5" class="px-6 py-10 text-center text-sm text-gray-400">{{ trans('members.no_results') ?? 'No members found.' }}</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    </div>

    @if(isset($users) && method_exists($users, 'links'))
        <div class="mt-4">{{ $users->links() }}</div>
    @endif
</div>
@endsection
