
@extends('admin.layouts.app')

@section('content')
<div x-data="membersPage()" class="space-y-6">
    <div class="dark-card">
        <div class="px-6 py-4 flex items-center justify-between border-b border-gray-700">
            <div>
                <h1 class="text-2xl font-bold text-white">{{ trans('members.manage_members') }}</h1>
                <p class="text-gray-400 mt-1">Manage user accounts and balances</p>
            </div>

            <div class="flex items-center space-x-4">
                <div class="relative">
                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                        <i class="fas fa-search text-gray-400"></i>
            <div class="absolute inset-y-0 right-0 pr-3 flex items-center" x-show="loading" x-cloak>
                <svg class="animate-spin h-5 w-5 text-indigo-300" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v4a4 4 0 00-4 4H4z"></path>
                </svg>
            </div>
                    </div>
                    <input x-model.debounce.300="query" @input="search()" id="search" type="text" class="pl-10 pr-4 py-2 w-64" placeholder="{{ trans('members.fields.search.placeholder') }}">
                </div>
            </div>
                <div x-show="query.length" x-cloak>
                    <div x-show="loading" class="text-sm text-gray-400 mb-3">Searching...</div>
                    <div x-show="!loading && users.length" class="overflow-x-auto">
                        <table class="min-w-full">
                            <thead>
                                <tr>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">ID</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Name</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Balance</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Role</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-700">
                                <template x-for="user in users.slice(0,50)" :key="user.id">
                                    <tr class="hover:bg-gray-700/50 transition-colors">
                                        <td class="px-4 py-3 text-sm text-gray-300" x-text="user.id"></td>
                                        <td class="px-4 py-3 whitespace-nowrap">
                                            <div class="flex items-center">
                                                <div class="w-10 h-10 rounded-lg flex items-center justify-center mr-3" style="background: linear-gradient(135deg, #2a2f3a, #3b3f4a);">
                                                    <i class="fas fa-user text-white text-sm"></i>
                                                </div>
                                                <div>
                                                    <div class="text-sm font-medium text-white"><a href="#" @click.prevent.stop="openManage(user)" x-text="user.name"></a></div>
                                                    <div class="text-sm text-gray-400">ID: <span x-text="user.id"></span></div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="px-4 py-3">
                                            <div class="flex items-center space-x-3">
                                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-gray-700 text-white">
                                                    <i class="fas fa-coins mr-1"></i><span x-text="user.money_formatted"></span>
                                                </span>
                                                <button @click.prevent.stop="openModal(user)" class="text-xs bg-emerald-600 text-white rounded px-2 py-1">Add Balance</button>
                                                <button @click.prevent.stop="openManage(user)" class="text-xs bg-gray-800 text-white rounded px-2 py-1">Manage</button>
                                            </div>
                                        </td>
                                        <td class="px-4 py-3">
                                            <div class="flex items-center space-x-2">
                                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-gray-700 text-white" x-text="user.role_label"></span>
                                                <div>
                                                    <form method="post" :action="'{{ url('admin/members/role') }}/' + user.id">
                                                        {!! csrf_field() !!}
                                                        <select name="role" @change="(e)=>{ var role = e.target.value; fetch('{{ url('admin/members/role') }}/' + user.id, { method: 'POST', headers: { 'X-CSRF-TOKEN':'{{ csrf_token() }}', 'Content-Type':'application/x-www-form-urlencoded' }, body: 'role='+encodeURIComponent(role) }).then(r=>r.json()).then(d=>{ if(d.status==='ok'){ user.role = d.role; user.role_label = d.role.split(' ').map(function(w){ return w.charAt(0).toUpperCase()+w.slice(1); }).join(' '); } }).catch(()=>{}); }" class="bg-gray-800 text-white text-xs rounded px-2 py-1">
                                                            <option value="member">member</option>
                                                            <option value="game master">game master</option>
                                                            <option value="administrator">administrator</option>
                                                        </select>
                                                    </form>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                </template>
                            </tbody>
                        </table>
                    </div>
                    <div x-show="!loading && !users.length" class="text-center text-gray-400 py-6">No results</div>
                </div>
            </template>

            <template x-if="!users.length">
                <div class="text-center py-12 text-gray-400">
                    <div class="w-24 h-24 mx-auto mb-6 bg-gray-700 rounded-full flex items-center justify-center">
                        <i class="fas fa-users text-4xl"></i>
                    </div>
                    <h3 class="text-xl font-semibold text-white mb-2">No members found</h3>
                    <p>No user accounts match your search.</p>
                </div>
            </template>

            <!-- Pagination: keep server-side pagination links (works when not searching) -->
            @if($users->hasPages())
                <div class="mt-6" x-show="!query">
                    {!! $users->render() !!}
                </div>
            @endif

            <!-- Server-side fallback table (visible only if Alpine isn't running) -->
            <div id="server-users" class="mt-6" x-show="!query.length">
                @if(isset($users) && $users->count())
                    <div class="overflow-x-auto">
                        <table class="min-w-full">
                            <thead>
                                <tr>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">{{ trans('members.table.id') }}</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">{{ trans('members.table.name') }}</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">{{ trans('members.table.balance') }}</th>
                                    <th class="px-4 py-2 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">{{ trans('members.table.role') }}</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-gray-700">
                                @foreach($users as $u)
                                    <tr class="hover:bg-gray-700/50 transition-colors">
                                        <td class="px-4 py-3 text-sm text-gray-300">{{ $u->ID }}</td>
                                        <td class="px-4 py-3 whitespace-nowrap">
                                            <div class="flex items-center">
                                                <div class="w-10 h-10 rounded-lg flex items-center justify-center mr-3" style="background: linear-gradient(135deg, #2a2f3a, #3b3f4a);">
                                                    <i class="fas fa-user text-white text-sm"></i>
                                                </div>
                                                <div>
                                                    <div class="text-sm font-medium text-white"><a href="#" @click.prevent.stop="openManage({ id: {{ $u->ID }}, name: '{{ addslashes($u->name) }}', email: '{{ addslashes($u->email) }}', money: {{ $u->money }} })">{{ $u->name }}</a></div>
                                                    <div class="text-sm text-gray-400">ID: {{ $u->ID }}</div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="px-4 py-3">
                                            <div class="flex items-center space-x-3">
                                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-gray-700 text-white">
                                                    <i class="fas fa-coins mr-1"></i>{{ number_format($u->money) }}
                                                </span>
                                                <button onclick="document.querySelector('[x-data]') && (function(){ var comp = document.querySelector('[x-data]'); /* trigger Alpine openModal via global function */ })(); return false;" @click.prevent.stop="openModal({id: {{ $u->ID }}, name: '{{ addslashes($u->name) }}', money_formatted: '{{ number_format($u->money) }}' })" class="text-xs bg-emerald-600 text-white rounded px-2 py-1">Add Balance</button>
                                            </div>
                                        </td>
                                        <td class="px-4 py-3">
                                            <div class="flex items-center space-x-2">
                                                <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-gray-700 text-white">{{ $u->role }}</span>
                                                <form method="post" action="{{ url('admin/members/role/'.$u->ID) }}" class="inline-block">
                                                    {!! csrf_field() !!}
                                                    <select name="role" onchange="this.form.submit()" class="bg-gray-800 text-white text-xs rounded px-2 py-1">
                                                        <option value="member" {{ $u->role == 'member' ? 'selected' : '' }}>member</option>
                                                        <option value="game master" {{ $u->role == 'game master' ? 'selected' : '' }}>game master</option>
                                                        <option value="administrator" {{ $u->role == 'administrator' ? 'selected' : '' }}>administrator</option>
                                                    </select>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    <div class="mt-6">
                        {!! $users->render() !!}
                    </div>
                @else
                    <div class="text-center py-12 text-gray-400">
                        <h3 class="text-xl font-semibold text-white mb-2">No members found</h3>
                        <p>No user accounts available.</p>
                    </div>
                @endif
            </div>

            <!-- Balance Modal -->
    <div x-show="modalOpen" x-cloak class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50">
        <div class="dark-card max-w-md w-full mx-4" @click.stop>
            <div class="px-6 py-4 border-b border-gray-700 flex items-center justify-between">
                <h3 class="text-lg font-semibold text-white" x-text="modalTitle">Add Balance</h3>
                <button @click="closeModal()" class="text-gray-400 hover:text-white"><i class="fas fa-times"></i></button>
            </div>
            <form :action="balanceAction" method="post" class="p-6">
                {!! csrf_field() !!}
                <div class="mb-6">
                    <label for="amount" class="block text-sm font-medium text-gray-300 mb-2">{{ trans('members.fields.amount.label') }}</label>
                    <input name="amount" type="number" step="0.01" class="w-full" id="amount" placeholder="Enter amount..." required>
                </div>
                <div class="flex justify-end space-x-3">
                    <button type="button" @click="closeModal()" class="px-3 py-2 rounded-md bg-gray-600 text-white">{{ trans('members.modal.close') }}</button>
                    <button type="submit" class="px-3 py-2 rounded-md bg-indigo-600 text-white">{{ trans('members.modal.submit') }}</button>
                </div>
            </form>
        </div>

    <!-- Inline Manage User Panel (replaces modal) -->
    <div x-show="manageUserOpen" x-cloak class="dark-card p-4 mb-6">
        <div class="flex items-center justify-between border-b border-gray-700 pb-3 mb-4">
            <h3 class="text-lg font-semibold text-white" x-text="manageTitle">Manage User</h3>
            <button @click="closeManage()" class="text-gray-400 hover:text-white"><i class="fas fa-times"></i></button>
        </div>
        <form @submit.prevent="submitManage" class="space-y-4">
            {!! csrf_field() !!}
            <div>
                <label class="block text-sm text-gray-300 mb-1">Name</label>
                <input x-model="manageUserData.name" type="text" class="w-full" required>
            </div>
            <div>
                <label class="block text-sm text-gray-300 mb-1">Email</label>
                <input x-model="manageUserData.email" type="email" class="w-full" required>
            </div>
            <div>
                <label class="block text-sm text-gray-300 mb-1">Role</label>
                <select x-model="manageUserData.role" class="w-full bg-gray-800 text-white text-sm px-2 py-1 rounded">
                    <option value="member">member</option>
                    <option value="game master">game master</option>
                    <option value="administrator">administrator</option>
                </select>
            </div>
            <div>
                <label class="block text-sm text-gray-300 mb-1">Balance (absolute)</label>
                <input x-model="manageUserData.balance" type="number" step="0.01" class="w-full" placeholder="Leave blank to keep current balance">
            </div>
            <div class="flex justify-end space-x-3">
                <button type="button" @click="closeManage()" class="px-3 py-2 rounded-md bg-gray-600 text-white">Cancel</button>
                <button type="submit" class="px-3 py-2 rounded-md bg-indigo-600 text-white">Save</button>
            </div>
        </form>
    </div>

@push('scripts')
<script>
// membersPage component - defined early so Alpine can reference it
function membersPage() {
    // server-side initial users (safe raw JSON)
    var initialUsers = {!! json_encode($users->map(function($u){ $r = strtolower($u->role); return ['id'=>$u->ID,'name'=>$u->name,'email'=>$u->email,'money'=>$u->money,'money_formatted'=>number_format($u->money),'role'=>$r,'role_label'=>ucwords($r),'menuOpen'=>false]; })->values()) !!};

    return {
        query: '',
        users: initialUsers.slice(),
        loading: false,
    modalOpen: false,
        modalTitle: '',
        balanceAction: '',
        // Manage modal state
        manageUserOpen: false,
        manageUserData: {},
        manageTitle: '',
    // grace timers to ignore immediate click-away after opening
    modalIgnoreCloseUntil: 0,
    manageIgnoreCloseUntil: 0,
        searchTimer: null,

        openModal(user) {
            this.modalTitle = 'Add ' + {!! json_encode(settings('currency_name')) !!} + ' to ' + user.name;
            this.balanceAction = '{{ url('admin/members/balance') }}/' + user.id;
            // set a short grace period so a lingering document click doesn't immediately close the modal
            this.modalIgnoreCloseUntil = Date.now() + 200;
            console.log('openModal called for user', user, 'ignoreUntil', this.modalIgnoreCloseUntil);
            console.trace('openModal trace');
            // open on next tick to avoid click-away race
            var self = this;
            setTimeout(function(){ self.modalOpen = true; }, 10);
        },

        openManage(user) {
            // Accept either a user object or an Event (fallback). This makes the handler robust when called
            // from server-side rows or when the caller doesn't pass a full object.
            var reconstructed = false;
            try {
                // if an Event was passed, try to extract data attributes from the target
                if (user && (user instanceof Event || user.constructor && user.constructor.name === 'Event')) {
                    var ev = user;
                    var el = ev.currentTarget || ev.target;
                    if (el) {
                        var ds = el.dataset || (el.closest ? (el.closest('[data-user-id]') || {}).dataset : null);
                        if (ds && (ds.userId || ds.user)) {
                            user = { id: ds.userId || ds.user, name: ds.userName || ds.userName || ds.user || '', email: ds.userEmail || '' };
                            reconstructed = true;
                        }
                    }
                }
            } catch (e) { console.warn('openManage: event dataset parse failed', e); }

            // if caller passed an element (not event) with dataset
            try {
                if (user && user.dataset) {
                    var ds2 = user.dataset;
                    if (ds2.userId) {
                        user = { id: ds2.userId, name: ds2.userName || '', email: ds2.userEmail || '' };
                        reconstructed = true;
                    }
                }
            } catch (e) { /* ignore */ }

            // compute id/name/email from any shape
            var uid = (user && (user.id || user.ID || user.ID === 0)) ? (user.id || user.ID) : null;
            var uname = (user && (user.name || user.Name)) ? (user.name || user.Name) : '';
            var uemail = (user && (user.email || user.Email)) ? (user.email || user.Email) : '';
            var urole = (user && user.role) ? user.role : (user && user.role_label ? user.role_label.toString().toLowerCase() : 'member');

            // if there's no valid id, abort opening — prevents empty modal on pages that already list members
            if (!uid) {
                console.log('openManage aborted: missing user id', user, 'reconstructed?', reconstructed);
                return;
            }

            this.manageUserData = { id: uid, name: uname, email: uemail, role: (urole || '').toString().toLowerCase(), balance: '' };
            this.manageTitle = 'Manage ' + (uname || 'User');
            // set a short grace period so a lingering document click doesn't immediately close the modal
            this.manageIgnoreCloseUntil = Date.now() + 200;
            console.log('openManage proceeding for user', this.manageUserData, 'ignoreUntil', this.manageIgnoreCloseUntil);
            console.trace('openManage trace');
            var self = this;
            setTimeout(function(){ self.manageUserOpen = true; }, 10);
        },

        // NOTE: overlayClose removed; Manage UI is now inline and uses closeManage directly

        closeManage() {
            // ignore close requests that happen immediately after opening
            if (this.manageIgnoreCloseUntil && Date.now() < this.manageIgnoreCloseUntil) return;
            console.log('closeManage called; proceeding to close', this.manageUserData);
            console.trace('closeManage trace');
            this.manageUserOpen = false;
            this.manageUserData = {};
            this.manageIgnoreCloseUntil = 0;
        },

        closeModal() {
            // ignore close requests that happen immediately after opening
            if (this.modalIgnoreCloseUntil && Date.now() < this.modalIgnoreCloseUntil) return;
            console.log('closeModal called; proceeding to close');
            console.trace('closeModal trace');
            this.modalOpen = false;
            this.modalIgnoreCloseUntil = 0;
            var amt = document.getElementById('amount'); if (amt) amt.value = '';
        },

        search() {
            if (!this.query || this.query.length === 0) {
                this.users = initialUsers.slice();
                this.loading = false;
                return;
            }

            this.loading = true;

            // Use URL-encoded POST which Laravel accepts reliably
            var params = new URLSearchParams();
            params.append('search_query', this.query);

            fetch('{{ url('admin/members/search') }}', {
                method: 'POST',
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Accept': 'application/json', 'Content-Type': 'application/x-www-form-urlencoded' },
                body: params.toString()
            })
            .then(function(r){ return r.json(); })
            .then(function(data){
                this.users = data.map(function(u){
                    var role = (u.role || '').toString().toLowerCase();
                    var role_label = role.split(' ').map(function(w){ return w.charAt(0).toUpperCase()+w.slice(1); }).join(' ');
                    return { id: u.ID, name: u.name, money: u.money, money_formatted: Number(u.money).toLocaleString(), role: role, role_label: role_label, menuOpen: false };
                }.bind(this));
                this.loading = false;
            }.bind(this))
            .catch(function(err){ console.error(err); this.loading = false; }.bind(this));
        }
        ,
        changeRole(user, newRole) {
            var params = new URLSearchParams();
            params.append('role', newRole);

            fetch('{{ url('admin/members/role') }}/' + user.id, {
                method: 'POST',
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Accept': 'application/json', 'Content-Type': 'application/x-www-form-urlencoded' },
                body: params.toString()
            })
            .then(function(r){ return r.json(); })
            .then(function(data){
                if (data.status === 'ok') {
                    user.role = data.role;
                    user.role_label = data.role.split(' ').map(function(w){ return w.charAt(0).toUpperCase()+w.slice(1); }).join(' ');
                }
            })
            .catch(function(err){ console.error(err); });
        }
        ,
        submitManage() {
            var payload = new URLSearchParams();
            payload.append('name', this.manageUserData.name);
            payload.append('email', this.manageUserData.email);
            payload.append('role', this.manageUserData.role);
            if (this.manageUserData.balance !== undefined && this.manageUserData.balance !== null && String(this.manageUserData.balance).length) {
                payload.append('balance', this.manageUserData.balance);
            }

            fetch('{{ url('admin/members/update') }}/' + this.manageUserData.id, {
                method: 'POST',
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}', 'Accept': 'application/json', 'Content-Type': 'application/x-www-form-urlencoded' },
                body: payload.toString()
            })
            .then(function(r){ return r.json(); })
            .then(function(data){
                if (data.status === 'ok') {
                    // update local user row if present
                    var idx = this.users.findIndex(function(u){ return String(u.id) === String(data.user.id) || String(u.ID) === String(data.user.id); }.bind(this));
                    if (idx !== -1) {
                        this.users[idx].name = data.user.name;
                        this.users[idx].email = data.user.email || this.users[idx].email;
                        this.users[idx].role = (data.user.role || '').toString().toLowerCase();
                        this.users[idx].role_label = (data.user.role || '').split(' ').map(function(w){ return w.charAt(0).toUpperCase()+w.slice(1); }).join(' ');
                        if (typeof data.user.money !== 'undefined') {
                            this.users[idx].money_formatted = Number(data.user.money).toLocaleString();
                        }
                    }
                    flashMessage('User updated');
                    this.closeManage();
                }
            }.bind(this))
            .catch(function(err){ console.error(err); });
        }
    }
}
</script>
<script>
// simple flashMessage helper used by Alpine actions
function flashMessage(msg) {
    try {
        var el = document.createElement('div');
        el.textContent = msg;
        el.style.position = 'fixed';
        el.style.bottom = '20px';
        el.style.right = '20px';
        el.style.background = '#111827';
        el.style.color = 'white';
        el.style.padding = '10px 14px';
        el.style.borderRadius = '6px';
        el.style.boxShadow = '0 4px 12px rgba(0,0,0,0.4)';
        document.body.appendChild(el);
        setTimeout(function(){ el.style.opacity = '0'; setTimeout(function(){ el.remove(); }, 400); }, 2500);
    } catch (e) { alert(msg); }
}
</script>
<script>
// Diagnostic document click logger: logs clicks when either modal is visible
</script>
</script>
@endpush

@endsection