@extends('admin.layouts.app')

@section('content')
<div class="p-6">
    <h1 class="text-2xl font-bold text-white mb-4">Manage Modal Test</h1>

    <div x-data="membersPage()" class="space-y-4">
        <div class="space-x-3">
            <button @click.prevent.stop="openManage({ id: 1, name: 'Test User 1', email: 'one@example.test' })" class="px-3 py-2 bg-indigo-600 text-white rounded">Open Manage (object)</button>

            <button id="btn-event" data-user-id="2" data-user-name="Test User 2" data-user-email="two@example.test" @click.prevent.stop="openManage($event)" class="px-3 py-2 bg-green-600 text-white rounded">Open Manage (event + dataset)</button>

            <button id="btn-el" data-user-id="3" data-user-name="Test User 3" data-user-email="three@example.test" onclick="(function(el){ document.querySelector('[x-data]') && (function(){ var comp = document.querySelector('[x-data]'); /* no-op */ })(); })(this); return false;" @click.prevent.stop="openManage(this)" class="px-3 py-2 bg-emerald-600 text-white rounded">Open Manage (element dataset)</button>
        </div>

        <div class="mt-6">
            <p class="text-gray-400">Use the buttons above to open the Manage modal in an isolated container. This view is only for debugging.</p>
        </div>

        <!-- Reuse the modal markup by including the manage view snippet: duplicate minimal modal markup here -->
        <!-- Balance Modal (copied minimal) -->
        <div x-show="modalOpen" x-cloak class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50" @click="overlayClose('modal', $event)">
            <div class="dark-card max-w-md w-full mx-4" @click.stop>
                <div class="px-6 py-4 border-b border-gray-700 flex items-center justify-between">
                    <h3 class="text-lg font-semibold text-white" x-text="modalTitle">Add Balance</h3>
                    <button @click="closeModal()" class="text-gray-400 hover:text-white"><i class="fas fa-times"></i></button>
                </div>
                <form :action="balanceAction" method="post" class="p-6">
                    {!! csrf_field() !!}
                    <div class="mb-6">
                        <label for="amount" class="block text-sm font-medium text-gray-300 mb-2">Amount</label>
                        <input name="amount" type="number" step="0.01" class="w-full" id="amount" placeholder="Enter amount..." required>
                    </div>
                    <div class="flex justify-end space-x-3">
                        <button type="button" @click="closeModal()" class="px-3 py-2 rounded-md bg-gray-600 text-white">Close</button>
                        <button type="submit" class="px-3 py-2 rounded-md bg-indigo-600 text-white">Submit</button>
                    </div>
                </form>
            </div>
        </div>

        <!-- Manage Modal (copied minimal) -->
        <div x-show="manageUserOpen" x-cloak class="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50" @click="overlayClose('manage', $event)">
            <div class="dark-card max-w-md w-full mx-4" @click.stop>
                <div class="px-6 py-4 border-b border-gray-700 flex items-center justify-between">
                    <h3 class="text-lg font-semibold text-white" x-text="manageTitle">Manage User</h3>
                    <button @click="closeManage()" class="text-gray-400 hover:text-white"><i class="fas fa-times"></i></button>
                </div>
                <form @submit.prevent="submitManage" class="p-6">
                    {!! csrf_field() !!}
                    <div class="mb-4">
                        <label class="block text-sm text-gray-300 mb-1">Name</label>
                        <input x-model="manageUserData.name" type="text" class="w-full" required>
                    </div>
                    <div class="mb-4">
                        <label class="block text-sm text-gray-300 mb-1">Email</label>
                        <input x-model="manageUserData.email" type="email" class="w-full" required>
                    </div>
                    <div class="flex justify-end space-x-3">
                        <button type="button" @click="closeManage()" class="px-3 py-2 rounded-md bg-gray-600 text-white">Close</button>
                        <button type="submit" class="px-3 py-2 rounded-md bg-indigo-600 text-white">Save</button>
                    </div>
                </form>
            </div>
        </div>

    </div>
</div>
@endsection
