@extends('admin.layouts.app')

@section('content')
<div class="w-full mx-auto">
    <!-- Page header moved above the card -->
    <div class="mb-6">
        <div class="flex items-center justify-between">
            <div>
                <h1 class="text-2xl font-bold text-white">{{ trans('news.create_article') }}</h1>
                <p class="text-gray-400 mt-1">{{ trans('news.create_desc') }}</p>
            </div>
            <div class="flex items-center space-x-3">
                <div class="w-12 h-12 bg-gradient-to-br from-blue-600 to-indigo-600 rounded-lg flex items-center justify-center">
                    <i class="fas fa-newspaper text-white"></i>
                </div>
            </div>
        </div>
    </div>

    <div class="dark-card">
        <div class="p-6">
            {!! Form::model($article = new \App\Article, ['url' => route('admin.news.index'), 'class' => '']) !!}
                @include('admin.news.form', ['submitButtonText' => trans('news.add_button')])
            {!! Form::close() !!}
        </div>
@endsection
