@extends('admin.layouts.app')

@section( 'content' )
    <div class="dark-card">
        <div class="p-6 overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-700">
                <thead>
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">ID</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">{{ trans('news.table.title') ?? 'Title' }}</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">{{ trans('news.table.category') ?? 'Category' }}</th>
                        <th class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">{{ trans('news.table.date') ?? 'Date' }}</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-300 uppercase tracking-wider">{{ trans('main.actions') ?? 'Actions' }}</th>
                    </tr>
                </thead>
                <tbody class="bg-transparent divide-y divide-gray-700">
                    @foreach($articles as $article)
                        <tr class="hover:bg-gray-700/50">
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ $article->id }}</td>
                            <td class="px-6 py-4">
                                <div class="text-sm font-medium text-white">{{ $article->title }}</div>
                                <div class="text-xs text-gray-400 mt-1">{{ strlen(strip_tags($article->content)) > 120 ? mb_substr(strip_tags($article->content),0,120) . '...' : strip_tags($article->content) }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ ucfirst($article->category) }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ $article->created_at ? $article->created_at->format('Y-m-d') : '' }}</td>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-right">
                                <a href="{{ route('admin.news.edit', $article->id) }}" class="text-indigo-300 hover:text-indigo-200 mr-3" title="{{ trans('main.edit') }}"><i class="fas fa-pencil-alt"></i></a>
                                <a href="{{ route('admin.news.destroy', $article->id) }}" class="text-red-400 hover:text-red-300 delete" title="{{ trans('main.remove') }}"><i class="fas fa-trash"></i></a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

            <div class="mt-6">
                {!! $articles->render() !!}
            </div>
        </div>
    </div>
@endsection

@section( 'footer' )
    @parent
    <script>
        $('.delete').click(function (e) {
            e.preventDefault();
            e.stopPropagation();

            var article_title = $(this).closest('div.panel.panel-default').find('#title').html();

            $.ajax({
                method: 'DELETE',
                url: $(this).attr('href'),
                data: {
                    '_token' : "{{ csrf_token() }}"
                },
                success: function (response) {
                    $('div.panel.panel-default').filter(function() {
                        return $(this).find('#title').text() === article_title
                    }).remove();
                },
                error: function (response) {
                    // handle error
                }
            });
        });
    </script>
@endsection
