@extends('admin.layouts.app')

@section('content')
    <div class="space-y-4">
        <h2 class="text-xl font-semibold">{{ trans('main.settings') }} — {{ trans('main.apps.ranking') }}</h2>
        <div class="text-sm text-gray-400">{{ settings('server_name') }}</div>

        <div class="dark-card p-4">
            <form action="{{ url('admin/ranking/settings') }}" method="post" class="space-y-6">
                {!! csrf_field() !!}

                <div>
                    <label class="block text-sm font-medium text-gray-300">{{ trans('ranking.fields.ignore_roles', [], null) ?: 'Ignore Roles (comma-separated role IDs)' }}</label>
                    <input name="ranking_ignore_roles" type="text" value="{{ old('ranking_ignore_roles', settings('ranking_ignore_roles')) }}" class="mt-1 block w-full bg-gray-800 border border-gray-700 rounded-md px-3 py-2 text-gray-200">
                    <p class="text-sm text-gray-500 mt-1">{{ trans('ranking.help.ignore_roles', [], null) ?: 'Comma separated role IDs to exclude from ranking.' }}</p>
                </div>

                <div>
                    <label class="block text-sm font-medium text-gray-300">{{ trans('ranking.fields.ignore_factions', [], null) ?: 'Ignore Factions (comma-separated faction IDs)' }}</label>
                    <input name="ranking_ignore_factions" type="text" value="{{ old('ranking_ignore_factions', settings('ranking_ignore_factions')) }}" class="mt-1 block w-full bg-gray-800 border border-gray-700 rounded-md px-3 py-2 text-gray-200">
                    <p class="text-sm text-gray-500 mt-1">{{ trans('ranking.help.ignore_factions', [], null) ?: 'Comma separated faction IDs to exclude from ranking.' }}</p>
                </div>

                <div class="flex justify-end pt-4">
                    <button type="submit" class="inline-flex items-center px-4 py-2 rounded-md bg-indigo-600 hover:bg-indigo-500 text-white font-semibold">{{ trans('main.save_settings') }}</button>
                </div>
            </form>
        </div>
    </div>

@endsection
